% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resid.R
\name{addNpde}
\alias{addNpde}
\title{NPDE calculation for nlmixr}
\usage{
addNpde(
  object,
  updateObject = TRUE,
  table = tableControl(),
  ...,
  envir = parent.frame(1)
)
}
\arguments{
\item{object}{nlmixr fit object}

\item{updateObject}{Boolean indicating if original object should be updated.  By default this is TRUE.}

\item{table}{`tableControl()` list of options}

\item{...}{Other ignored parameters.}

\item{envir}{Environment that should be checked for object to
update.  By default this is the global environment.}
}
\value{
New nlmixr fit object
}
\description{
NPDE calculation for nlmixr
}
\examples{

\donttest{

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

f <- nlmixr(one.cmt, theo_sd, "saem")

# even though you may have forgotten to add the NPDE, you can add it to the data.frame:

f <- addNpde(f)

}
}
\author{
Matthew L. Fidler
}
