% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGroup.SUBMODEL.TVC_helper.R
\name{getsub.TVC_m}
\alias{getsub.TVC_m}
\title{Define a Latent Growth Curve Model or Latent Change Score Model with a Time-varying Covariate as Class-specific Models
(Submodels) for a Longitudinal Multiple Group Model.}
\usage{
getsub.TVC_m(
  dat,
  nClass,
  grp_var,
  t_var,
  y_var,
  curveFun,
  intrinsic,
  records,
  y_model,
  TVC,
  decompose,
  growth_TIC,
  starts
)
}
\arguments{
\item{dat}{A wide-format data frame, with each row corresponding to a unique ID. It contains the observed variables with
repeated measurements and occasions for each longitudinal process, and time-invariant covariates (TICs) if any.
It takes the value passed from \code{getMGroup()}.}

\item{nClass}{An integer specifying the number of manifested classes for the multiple group model. It takes the value passed from \code{getMGroup()}.}

\item{grp_var}{A string specifying the column that indicates manifested classes. It takes the value passed from \code{getMGroup()}.}

\item{t_var}{A string specifying the prefix of the column names corresponding to the time variable at each study wave.
It takes the value passed from \code{getMGroup()}.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMGroup()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options for \code{y_model =
"LGCM"} include: \code{"linear"} (or \code{"LIN"}), \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"bilinear spline"} (or \code{"BLS"}). Supported
options for \code{y_model = "LCSM"} include: \code{"quadratic"} (or \code{"QUAD"}), \code{"negative exponential"}
(or \code{"EXP"}), \code{"Jenss-Bayley"} (or \code{"JB"}), and \code{"nonparametric"} (or \code{"NonP"}). It takes the
value passed from \code{getMGroup()}.}

\item{intrinsic}{A logical flag indicating whether to build an intrinsically nonlinear longitudinal model. It takes the
value passed from \code{getMGroup()}.}

\item{records}{A numeric vector specifying the indices of the observed study waves. It takes the value passed from
\code{getMGroup()}.}

\item{y_model}{A string specifying how to fit the longitudinal outcome. Supported values are \code{"LGCM"} and \code{"LCSM"}.
It takes the value passed from \code{getMGroup()}.}

\item{TVC}{A string specifying the prefix of the column names corresponding to the time-varying covariate at each study wave.
It takes the value passed from \code{getMGroup()}.}

\item{decompose}{An integer specifying the decomposition option for temporal states. Supported values include \code{0} (no
decomposition), \code{1} (decomposition with interval-specific slopes as temporal states), \code{2} (decomposition with interval-
specific changes as temporal states), and \code{3} (decomposition with change-from-baseline as temporal states). It takes the
value passed from \code{getMGroup()}.}

\item{growth_TIC}{A string or character vector specifying the column name(s) of time-invariant covariate(s) that account for the
variability of growth factors, if any. It takes the value passed from \code{getMGroup()}.}

\item{starts}{A list of initial values for the parameters, either takes the value passed from \code{getMGroup()}
or derived by the helper function \code{getMGroup.initial()}.}
}
\value{
A list of manifest and latent variables and paths for an mxModel object.
}
\description{
This function defines a latent growth curve model or latent change score model with time-varying covariate as class-
specific models (submodels) for a longitudinal multiple group model.
}
\keyword{internal}
