% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SStrlin.R
\name{SStrlin}
\alias{SStrlin}
\alias{trlin}
\title{self start for a trilinear Function}
\usage{
trlin(x, a, b, xs1, c, xs2, d)

SStrlin(x, a, b, xs1, c, xs2, d)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the first-phase slope}

\item{xs1}{first break-point of transition between first-phase linear and second-phase linear}

\item{c}{the second-phase slope}

\item{xs2}{second break-point of transition between second-phase linear and third-phase linear}

\item{d}{the third-phase slope}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

trlin: vector of the same length as x using the tri-linear function
}
\description{
Self starter for a tri-linear function with parameters a (intercept), b (first slope), xs1 (first break-point), c (second slope), xs2 (second break-point) and d (third slope)
}
\details{
This is a special case with just three parts (and two break points) but a more general approach 
is to consider a segmented function with several breakpoints and linear segments. 
Splines would be even more general. Also this model assumes that there are two break-points that needs 
to be estimated. The guess for the initial values splits the dataset in half, so it this will work
when one break-point is in the first half and the second is in the second half.
}
\examples{
\donttest{
require(ggplot2)
set.seed(1234)
x <- 1:30
y <- trlin(x, 0.5, 2, 10, 0.1, 20, 1.75) + rnorm(30, 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SStrlin(x, a, b, xs1, c, xs2, d), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
\seealso{
package \pkg{segmented}.
}
