% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSpquad.R
\name{SSpquad}
\alias{SSpquad}
\alias{pquad}
\title{self start for plateau-quadratic function}
\usage{
pquad(x, a, xs, b, c)

SSpquad(x, a, xs, b, c)
}
\arguments{
\item{x}{input vector}

\item{a}{the plateau value}

\item{xs}{break-point of transition between plateau and quadratic}

\item{b}{the slope (linear term)}

\item{c}{quadratic term}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

pquad: vector of the same length as x using the plateau-quadratic function
}
\description{
Self starter for plateau-quadratic function with parameters a (plateau), xs (break-point), b (slope), c (quadratic)
}
\details{
Reference for nonlinear regression Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506).
}
\examples{
\donttest{
require(ggplot2)
set.seed(12345)
x <- 1:40
y <- pquad(x, 5, 20, 1.7, -0.04) + rnorm(40, 0, 0.6)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSpquad(x, a, xs, b, c), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
confint(fit)
}
}
