% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSquadp3.R
\name{SSquadp3}
\alias{SSquadp3}
\alias{quadp3}
\title{self start for quadratic-plateau function}
\usage{
quadp3(x, a, b, c)

SSquadp3(x, a, b, c)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the slope}

\item{c}{quadratic term}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

quadp: vector of the same length as x using the quadratic-plateau function
}
\description{
Self starter for quadratic plateau function with (three) parameters a (intercept), b (slope), c (quadratic)
}
\details{
The equation is, for a response (y) and a predictor (x): \cr
  \eqn{y ~ (x <= xs) * (a + b * x + c * x^2) + (x >= xs) * (a + (-b^2)/(4 * c))} \cr
  
where the break-point (xs) is -b/c \cr
and the asymptote is (a + (-b^2)/(4 * c))
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- quadp3(x, 5, 1.7, -0.04) + rnorm(30, 0, 0.6)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSquadp3(x, a, b, c), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
}
}
