% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlsic.R
\name{lsie_ln}
\alias{lsie_ln}
\title{Linear Least Squares problem with inequality and equality constraints, least norm solution}
\usage{
lsie_ln(a, b, u = NULL, co = NULL, e = NULL, ce = NULL, rcond = 1e+10)
}
\arguments{
\item{a}{dense matrix A or its QR decomposition}

\item{b}{right hand side vector}

\item{u}{dense matrix of inequality constraints}

\item{co}{right hand side vector of inequality constraints}

\item{e}{dense matrix of equality constraints}

\item{ce}{right hand side vector of equality constraints}

\item{rcond}{maximal condition number for determining rank deficient matrix}
}
\value{
solution vector whose attribute 'mes' may contain a message about possible numerical problems
}
\description{
solve linear least square problem (min ||A\%\emph{\%x-b||)
with inequality constraints u\%}\%x>=co and equality constraints e\%*\%x=ce
Method:
reduce the pb to lsi_ln on the null-space of e
}
\seealso{
\link{lsi_ln}
}
