% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/000functions.R
\name{cond_expr}
\alias{cond_expr}
\title{\code{cond_expr} returns moments of conditional multivariate normal distribution X|Y (last 
variable is dependent). Only expression for X|Y. Requires installation of Maxima software.}
\usage{
cond_expr(neq, sdv, mv, nconteq = neq - 1, tex = FALSE)
}
\arguments{
\item{neq}{Number of equations/variables.}

\item{sdv}{Vector of standard deviation of normally distributed variables, e.g. c(NA, NA, NA, 1)
NA - unknown, any number - know.}

\item{mv}{Vector of means of normally distributed variables, e.g. rep(0, 4).}

\item{nconteq}{Number of continuous equations.}

\item{tex}{i if \code{TRUE} TeX expressions from wxMaxima are returned.}
}
\value{
List of strings. First element is an expression of conditional mean and covariance. 
The second element is a TeX formula.
}
\description{
\code{cond_expr} returns moments of conditional multivariate normal distribution X|Y (last 
variable is dependent). Only expression for X|Y. Requires installation of Maxima software.
}
\examples{
# this means that E[y3|y1,y2] and V[y3|y1,y2] will be returned
# all continuous w/ unknown means
\dontrun{
# To run this, one needs to install Maxima software
res <- cond_expr(neq=3)
# 3 continuous w/ unknown means and the last one with mean 0 and sd 1, d|c1c2c3
res <- cond_expr(neq=4, sdv=c(NA, NA, NA, 1), mv=c(NA, NA, NA, 0))
# 2 continuous w/ unknown means and 2 discrete with mean 0 and sd 1, d1|c1c2c3d2
res <- cond_expr(neq=4, sdv=c(NA, NA,  1, 1), mv=c(NA, NA,  0, 0), nconteq=2)
}
}
