% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/001functions.R
\name{prepare_data}
\alias{prepare_data}
\title{\code{prepare_data} prepare data for the estimation.}
\usage{
prepare_data(
  data,
  choice = "",
  dummy = "",
  PeID = "",
  WeID = "",
  type = "",
  mode_spec_var = "",
  avl = TRUE,
  chc = TRUE,
  wc = TRUE,
  wd = TRUE,
  nc = 0,
  weights = NULL,
  weight_paths = FALSE,
  weight_paths_cont = FALSE,
  mode_factors = NULL
)
}
\arguments{
\item{data}{\code{data.frame}}

\item{choice}{Name of variable with modes.}

\item{dummy}{Name of variable indicating, if the mode was chosen.}

\item{PeID}{Name of variable with individual identification numbers.}

\item{WeID}{Name of variable with trip identification.}

\item{type}{Type of data. If "long", then modifications are done.}

\item{mode_spec_var}{Used if format "long", mode specific variables.}

\item{avl}{if \code{TRUE}, includes dummies for mode availability.}

\item{chc}{if \code{TRUE}, includes dummies for choice of mode.}

\item{wc}{if \code{TRUE}, creates weights 1 for continuous equations.}

\item{wd}{if \code{TRUE}, creates weights 1 for discrete equations.}

\item{nc}{Integer, number of continuous equations.}

\item{weights}{Data matrix with weights, 
column names have to be $wc_i$(continuous), $wd_i$(discrete).}

\item{weight_paths}{if \code{TRUE}, weight according to number of trips per person, discrete part.}

\item{weight_paths_cont}{if \code{TRUE}, weight continuous part.}

\item{mode_factors}{if choice is not factor or numeric, this is important to supply.}
}
\value{
data.frame used for modeling.
}
\description{
\code{prepare_data} prepare data for the estimation.
}
\examples{
data("TravelMode", package = "AER")
mode_spec_var <- c("wait", "vcost", "travel", "gcost")
res <- prepare_data(TravelMode, choice="mode", dummy="choice", PeID="individual", WeID="",
type="long", mode_spec_var =mode_spec_var, nc=3)
}
