% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elm.fast.R
\name{predict.elm.fast}
\alias{predict.elm.fast}
\title{Predictions for ELM (fast) network.}
\usage{
\method{predict}{elm.fast}(object, newx, na.rm = c(FALSE, TRUE), ...)
}
\arguments{
\item{object}{ELM network object, produced using \code{\link{elm.fast}}.}

\item{newx}{Explanatory variables. Each column is a variable.}

\item{na.rm}{If TRUE remove columns and object produces an ensemble forecast, then remove any members that give NA in their forecasts.}

\item{...}{Unused argument.}
}
\value{
Returns a list with:
\itemize{
\item{\code{Y.hat}{ - Ensemble prediction.}}
\item{\code{Y.all}{ - Predictions of each training repetition.}}
}
}
\description{
Calculate predictions for ELM (fast) network.
}
\examples{
\dontshow{
 p <- 2000
 n <- 150
 X <- matrix(rnorm(p*n),nrow=n)
 b <- cbind(rnorm(p))
 Y <- X \%*\% b
 fit <- elm.fast(Y,X,reps=1)
 predict(fit,X)
}
\dontrun{
 p <- 2000
 n <- 150
 X <- matrix(rnorm(p*n),nrow=n)
 b <- cbind(rnorm(p))
 Y <- X \%*\% b
 fit <- elm.fast(Y,X)
 predict(fit,X)
}

}
\seealso{
\code{\link{elm.fast}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
\keyword{elm}
