% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_slope.R
\name{raster_slope}
\alias{raster_slope}
\title{Wrapper for \code{raster::terrain} for calculating slope on \code{stars} objects}
\usage{
raster_slope(x)
}
\arguments{
\item{x}{A \code{stars} object}
}
\value{
A \code{stars} object with the slope values, in decimal degrees
}
\description{
This is a wrapper around \code{raster::terrain} with \code{opt="slope"}, to calculate topographic slope on \code{stars} objects without needing to convert to and from a \code{Raster*} object.
}
\examples{
library(stars)
data(dem)
slope = raster_slope(dem)
plot(dem)
plot(slope)

}
