% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{ZceTk}
\alias{ZceTk}
\title{\eqn{Z}-test for Cuzick and Edwards \eqn{T_k} statistic}
\usage{
ZceTk(
  dat,
  cc.lab,
  k,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  case.lab = NULL,
  nonzero.mat = TRUE,
  asy.var = FALSE,
  ...
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{k}{Integer specifying the number of NNs (of subject \eqn{i}).}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for Cuzick and Edwards \eqn{T_k} statistic}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}}

\item{nonzero.mat}{A logical argument (default is \code{TRUE}) to determine whether the \eqn{A} matrix or the matrix of
nonzero locations of the \eqn{A} matrix will be used in the computation of \eqn{N_s} and \eqn{N_t} (argument is passed on to
\code{asyvarTk}). If \code{TRUE} the nonzero location matrix is used, otherwise the \eqn{A} matrix itself is used.}

\item{asy.var}{A logical argument (default is \code{FALSE}) to determine whether the asymptotic variance or 
the exact (i.e. finite sample) variance for the variance of \eqn{T_k} in its standardization. 
If \code{TRUE}, the asymptotic variance is used for \eqn{Var[T_k]}, otherwise the exact variance is used.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the Cuzick and Edwards \eqn{T_k} test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the Cuzick and Edwards \eqn{T_k} value
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the Cuzick and Edwards \eqn{T_k} value.}
\item{null.value}{Hypothesized null value for the Cuzick and Edwards \eqn{T_k} value
which is \eqn{k n_1 (n_1-1)/(n-1)} for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}}
}
\description{
An object of class \code{"htest"} performing a \eqn{z}-test for Cuzick and Edwards \eqn{T_k} test statistic based on the 
number of cases within \code{k}NNs of the cases in the data.

For disease clustering, \insertCite{cuzick:1990;textual}{nnspat} suggested a \code{k}-NN test \eqn{T_k} based on number of cases
among \code{k} NNs of the case points.
Under RL of \eqn{n_1} cases and \eqn{n_0} controls to the given locations in the study region,
\eqn{T_k} approximately has \eqn{N(E[T_k],Var[T_k]/n_1)} distribution for large \eqn{n_1}.

The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL}, 
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's 
and 1's accordingly. 
Also, \eqn{T_1} is identical to the count for cell \eqn{(1,1)} in the nearest neighbor contingency table (NNCT)
(See the function \code{\link{nnct}} for more detail on NNCTs).
Thus, the \eqn{z}-test for \eqn{T_k} is same as the cell-specific \eqn{z}-test for cell \eqn{(1,1)} in the NNCT (see
\code{\link{cell.spec}}).

The logical argument \code{nonzero.mat} (default=\code{TRUE}) is for using the \eqn{A} matrix if \code{FALSE} or just the matrix of nonzero
locations in the \eqn{A} matrix (if \code{TRUE}) in the computations.

The logical argument \code{asy.var} (default=\code{FALSE}) is for using the asymptotic variance or the exact (i.e. finite
sample) variance for the variance of \eqn{T_k} in its standardization.
If \code{asy.var=TRUE}, the asymptotic variance is used for \eqn{Var[T_k]} (see \code{asyvarTk}), otherwise the exact
variance (see \code{varTk}) is used.

See also (\insertCite{ceyhan:SiM-seg-ind2014,cuzick:1990;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
k<-1 #try also 2,3, sample(1:5,1)

ZceTk(Y,cls,k)
ZceTk(Y,cls,k,nonzero.mat=FALSE)
ZceTk(Y,cls,k,method="max")

ZceTk(Y,cls+1,k,case.lab = 2,alt="l")
ZceTk(Y,cls,k,asy.var=TRUE,alt="g")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}}, \code{\link{cell.spec}}, and \code{\link{Xsq.ceTk}}
}
\author{
Elvan Ceyhan
}
