% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsXsq.spec.cor}
\alias{funsXsq.spec.cor}
\alias{Xsq.spec.cor.ct}
\alias{Xsq.spec.cor}
\title{Overall Species Correspondence Test with Chi-square Approximation}
\usage{
Xsq.spec.cor.ct(ct, covSC, nnct = FALSE)

Xsq.spec.cor(dat, lab, ...)
}
\arguments{
\item{ct}{The NNCT or SCCT, used in \code{Xsq.spec.cor.ct} only}

\item{covSC}{The covariance matrix for the self entries (i.e. first column) in the SCCT
or the diagonal entries in the NNCT, used in \code{Xsq.spec.cor.ct} only. Usually output of the functions 
\code{\link{covNii.ct}} or \code{\link{covNii}}.}

\item{nnct}{A logical parameter (default=\code{FALSE}). If \code{TRUE}, \code{x} is taken to be the \eqn{k \times k} NNCT, 
and if \code{FALSE}, \code{x} is taken to be the IPD matrix, used in \code{Xsq.spec.cor.ct} only}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Xsq.spec.cor} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Xsq.spec.cor} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Xsq.spec.cor} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for overall species correspondence test}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is \eqn{k} for this function.}
\item{estimate}{The \code{vector} of estimates of the parameters, i.e., observed values of self entries 
in the SCCT or diagonal entries in the NNCT.}
\item{est.name,est.name2}{Names of the estimates, they are identical for this function.}
\item{null.value}{The \code{vector} of null values of the parameters, i.e., expected values of self entries 
in the SCCT or diagonal entries in the NNCT under RL or CSR.}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Xsq.spec.cor.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Xsq.spec.cor} only}
}
\description{
Two functions: \code{Xsq.spec.cor.ct} and \code{Xsq.spec.cor}.

Each one performs hypothesis tests of (simultaneous) equality of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the expected values of the diagonal entries \eqn{N_{ii}} in an NNCT
to the ones under RL or CSR.
That is, each performs the overall species correspondence test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
(See \insertCite{ceyhan:NNCorrespond2018;textual}{nnspat} for more detail).

Each test is based on the Chi-square approximation of the corresponding quadratic form for the first column
in a species correspondence contingency table (SCCT) or the diagonal entries \eqn{N_{ii}} in an NNCT and
are due to \insertCite{ceyhan:NNCorrespond2018}{nnspat}.

Each function yields the test statistic, \eqn{p}-value and \code{df} which is \eqn{k}, description of the 
alternative with the corresponding null values (i.e. expected values) of the self entries (i.e. first column) in the SCCT
or the diagonal entries in the NNCT and also the sample estimates (i.e. observed values) of these entries.
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis is that all 
\eqn{E[S_1,S_2,\ldots,S_k] = E[N_{11},N_{22},\ldots,N_{kk}] = ((n_1(n_1 - 1)/(n - 1),(n_2(n_2 - 1)/(n - 1),\ldots,(n_k(n_k - 1)/(n - 1) )}
where \eqn{n_i} is the size of class \eqn{i} and \eqn{n} is the data size.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-scct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

vsq<-varNii.ct(ct,Qv,Rv)
cv<-covNii.ct(ct,vsq,Qv,Rv)
Xsq.spec.cor.ct(ct,cv)
Xsq.spec.cor(Y,cls)
Xsq.spec.cor(Y,cls,method="max")

ct<-nnct(ipd,cls)
Xsq.spec.cor.ct(ct,cv,nnct = TRUE)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-scct(ipd,fcls)
Xsq.spec.cor.ct(ct,cv)
Xsq.spec.cor(Y,fcls)

ct<-nnct(ipd,fcls)
Xsq.spec.cor.ct(ct,cv,nnct=TRUE)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-scct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

vsq<-varNii.ct(ct,Qv,Rv)
cv<-covNii.ct(ct,vsq,Qv,Rv)
Xsq.spec.cor.ct(ct,cv)

ct<-nnct(ipd,cls)
Xsq.spec.cor.ct(ct,cv,nnct = TRUE)
Xsq.spec.cor(Y,cls)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zself.ref.ct}}, \code{\link{Zself.ref}}, \code{\link{Xsq.nnref.ct}} and \code{\link{Xsq.nnref}}
}
\author{
Elvan Ceyhan
}
