% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{NNdist2cl}
\alias{NNdist2cl}
\title{Distances between subjects from class \eqn{i} and their NNs from class \eqn{j}}
\usage{
NNdist2cl(x, i, j, lab, within.class.ind = FALSE, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{i, j}{class label of base class and NN classes, respectively.}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{within.class.ind}{A logical parameter (default=\code{FALSE}). If \code{TRUE}, index numbering of subjects 
is within the class, from 1 to class size (i.e., \code{1:n_i}), according to their order in the original data;
otherwise, index numbering within class is just the indices in the original data.}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns a \code{list} with three elements
 \item{nndist}{\eqn{n_i \times 3} matrix where \eqn{n_i} is the size of class \eqn{i} and first column is the subject index in 
 class \eqn{i}, second column is the subject index in NN class \eqn{j}, and third column contains the corresponding
 distances of each class \eqn{i} subject to its NN among class \eqn{j} subjects.}
 \item{base.class}{label of base class} 
 \item{nn.class}{label of NN class}
}
\description{
Returns the distances between subjects from class \eqn{i} and their nearest neighbors (NNs) from class \eqn{j}. 
The output is a \code{list} with first entry (\code{nndist}) being an \eqn{n_i \times 3} matrix where \eqn{n_i} is the size of class \eqn{i}
and first column is the subject index in class \eqn{i}, second column is the subject index in NN class \eqn{j},  
and third column contains the corresponding distances of each class \eqn{i} subject to its NN among class \eqn{j}
subjects. Class \eqn{i} is labeled as base class and class \eqn{j} is labeled as NN class.

The argument \code{within.class.ind} is a logical argument (default=\code{FALSE}) to determine the indexing of 
the class \eqn{i} subjects. If \code{TRUE}, index numbering of subjects is within the class, 
from 1 to class size (i.e., \code{1:n_i}), according to their order in the original data;
otherwise, index numbering within class is just the indices in the original data.

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.
}
\examples{
#3D data points
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
#two class case
clab<-sample(1:2,n,replace=TRUE) #class labels
table(clab)
NNdist2cl(ipd,1,2,clab)
NNdist2cl(Y,1,2,clab,is.ipd = FALSE)

NNdist2cl(ipd,1,2,clab,within = TRUE)

#three class case
clab<-sample(1:3,n,replace=TRUE) #class labels
table(clab)
NNdist2cl(ipd,2,1,clab)

#1D data points
n<-15
X<-as.matrix(runif(n))# need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
#two class case
clab<-sample(1:2,n,replace=TRUE) #class labels
table(clab)
NNdist2cl(ipd,1,2,clab)
NNdist2cl(X,1,2,clab,is.ipd = FALSE)

}
\seealso{
\code{\link{kthNNdist}}, \code{\link{kNNdist}}, and \code{\link{NNdist2cl}}
}
\author{
Elvan Ceyhan
}
