% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{NNsub}
\alias{NNsub}
\title{Finding the index of the NN of a given point among a subset of points}
\usage{
NNsub(ss, x, i, is.ipd = TRUE, ...)
}
\arguments{
\item{ss}{indices of subjects (i.e., row indices in the data set) among with the NN of subject is to be found}

\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{i}{index of (i.e., row number for) the subject whose NN is to be found.}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{...}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns a \code{list} with the elements
 \item{base.ind}{index of the base subject}
 \item{ss.ind}{the index (indices) i.e. row number(s) of the NN of subject \eqn{i} among the subjects with indices
provided in \code{ss}}
 \item{ss.dis}{distance from subject \eqn{i} to its NN among the subjects in \code{ss}}
}
\description{
Returns the index (indices) of the nearest neighbor(s) of subject \eqn{i} (other than subject \eqn{i}) among the indices of points 
provided in the subsample \code{ss} using the given data set or IPD matrix \code{x}. The indices in \code{ss} determine the
columns of the IPD matrix to be used in this function. 
It will yield a \code{vector} if there are ties, and subject indices correspond to rows (i.e. rows \code{1:n} ) if \code{x} 
is the data set and to rows or columns if \code{x} is the IPD matrix.  

The argument \code{is.ipd} is a logical argument (default=\code{TRUE}) to determine the structure of the argument \code{x}.
If \code{TRUE}, \code{x} is taken to be the inter-point distance (IPD) matrix, and if \code{FALSE}, \code{x} is taken to be the data set
with rows representing the data points.
}
\examples{
#3D data points bura
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
#indices of the subsample ss
ss<-sample(1:n,floor(n/2),replace=FALSE)
NNsub(ss,ipd,2)
NNsub(ss,Y,2,is.ipd = FALSE)
NNsub(ss,ipd,5)

#1D data points
n<-15
X<-as.matrix(runif(n))# need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
#two class case
clab<-sample(1:2,n,replace=TRUE) #class labels
#indices of the subsample ss
ss<-sample(1:n,floor(n/2),replace=FALSE)
NNsub(ss,ipd,2)
NNsub(ss,ipd,5)

#with possible ties in the data
Y<-matrix(round(runif(60)*10),ncol=3)
ipd<-ipd.mat(Y)
ss<-sample(1:20,10,replace=FALSE) #class labels
NNsub(ss,ipd,2)
NNsub(ss,ipd,5)

}
\seealso{
\code{\link{NN}} and \code{\link{kNN}}
}
\author{
Elvan Ceyhan
}
