% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exists.R
\name{docdb_exists}
\alias{docdb_exists}
\title{Check if a database exists}
\usage{
docdb_exists(src, key, ...)
}
\arguments{
\item{src}{source object, result of call to src}

\item{key}{(chartacter) A key. ignored for mongo}

\item{...}{Ignored for now}
}
\value{
logical, \code{TRUE} or \code{FALSE}
}
\description{
Check if a database exists
}
\details{
Note that with etcd, you have to prefix a key with a
forward slash.
}
\note{
no docdb_exists method for MongoDB at this time
}
\examples{
\dontrun{
# CouchDB
(src <- src_couchdb())
docout <- docdb_create(src, key = "mtcars2", value = mtcars)
docdb_exists(src, "mtcars2")
docdb_exists(src, "asdfadf")

# Elasticsearch
(src <- src_elastic())
if (docdb_exists(src, "iris")) docdb_delete(src, "iris")
docdb_exists(src, "iris")
docdb_create(src, "iris", iris)
docdb_exists(src, "iris")
docdb_exists(src, "adfadf")

# Redis
(src <- src_redis())
docdb_create(src, "mtcars", mtcars)
docdb_exists(src, "mtcars")
docdb_exists(src, "asdfasf")

# MongoDB
src <- src_mongo(collection = "mtcars")
docdb_create(src, key = "mtcars", value = mtcars)
docdb_exists(src, "mtcars")

# SQLite
(src <- src_sqlite())
docdb_create(src, "mtcars", mtcars)
docdb_exists(src, "mtcars")
docdb_exists(src, "yellowcheese")
}

}
