% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval.plot.R
\name{eval.plot}
\alias{eval.plot}
\title{Visualization of Evaluation Criteria}
\usage{
eval.plot(
  x,
  criteria = "all",
  style = "greys",
  opt.col = "red",
  main = "Cluster Evaluation",
  ...
)
}
\arguments{
\item{x}{An output of the \code{nomclust()} or \code{nomprox()} functions containing the \code{eval} and \code{opt} components.}

\item{criteria}{A \emph{character} string or character \emph{vector} specifying the criteria that are going to be visualized. It can be selected one particular criterion, a vector of criteria or all the available criteria by typing \code{"all"}.}

\item{style}{A \emph{character} string or a \emph{vector} of colors defines a graphical style of the produced plots. There are two predefined styles in the \bold{nomclust} package, namely \code{"greys"} and \code{"dark"}, but a custom color scheme can be set by a user as a vector of a length four.}

\item{opt.col}{An argument specifying a color that is used for the optimal number of clusters identification.}

\item{main}{A \emph{character} string with the chart title.}

\item{...}{Other graphical arguments compatible with the generic \code{plot()} function.}
}
\value{
The function returns a series of up to seven plots with evaluation criteria values and the graphical indication of the optimal numbers of clusters (for AIC, BIC, BK, PSFE, PSFM).
\cr
}
\description{
The function \code{eval.plot()} visualizes the values of seven evaluation criteria for the range of cluster solutions defined by the user in the \bold{nomclust}, \bold{evalclust} or \bold{nomprox} functions.
 It also indicates the optimal number of clusters determined by these criteria. The charts for the seven evaluation criteria in the \bold{nomclust} package.
}
\details{
The function can be applied to the output of the \code{nomclust()}, \code{evalclust()} or \code{nomprox()} object containing a \code{eval} and \code{opt} components.
}
\examples{
# sample data
data(data20)

# creating an object with results of hierarchical clustering 
hca.object <- nomclust(data20, measure = "iof", eval = TRUE)

# a default series of plots
eval.plot(hca.object)

# changing the color indicating the optimum number of clusters
eval.plot(hca.object, opt.col= "darkorange")

# selecting only AIC and BIC criteria with the dark style
eval.plot(hca.object, criteria = c("AIC", "BIC"), style = "dark")

}
\seealso{
\code{\link[nomclust]{dend.plot}}, \code{\link[nomclust]{nomclust}}, \code{\link[nomclust]{evalclust}}, \code{\link[nomclust]{nomprox}}.
}
\author{
Jana Cibulkova and Zdenek Sulc. \cr Contact: \email{jana.cibulkova@vse.cz}
}
