% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\encoding{UTF-8}
\name{osm_amenities}
\alias{osm_amenities}
\title{OpenStreetMap amenity database}
\format{
A \code{tibble} with with
100 rows and
fields:
\describe{
\item{category}{The category of the amenity}
\item{amenity}{The name of the amenity}
}
}
\source{
\url{https://wiki.openstreetmap.org/wiki/Key:amenity}
}
\description{
Database with the list of amenities available on OpenStreetMap.
}
\details{
\tabular{ll}{
   \strong{category} \tab \strong{amenity} \cr
   Sustenance \tab bar \cr
   Sustenance \tab biergarten \cr
   Sustenance \tab cafe \cr
   Sustenance \tab fast_food \cr
   Sustenance \tab food_court \cr
   Sustenance \tab ice_cream \cr
   Sustenance \tab pub \cr
   Sustenance \tab restaurant \cr
   Education \tab college \cr
   Education \tab driving_school \cr
   Education \tab kindergarten \cr
   Education \tab language_school \cr
   Education \tab library \cr
   Education \tab toy_library \cr
   Education \tab music_school \cr
   Education \tab school \cr
   Education \tab university \cr
   Transportation \tab bicycle_parking \cr
   Transportation \tab bicycle_repair_station \cr
   Transportation \tab bicycle_rental \cr
   Transportation \tab boat_rental \cr
   Transportation \tab boat_sharing \cr
   Transportation \tab bus_station \cr
   Transportation \tab car_rental \cr
   Transportation \tab car_sharing \cr
   Transportation \tab car_wash \cr
   Transportation \tab vehicle_inspection \cr
   Transportation \tab charging_station \cr
   Transportation \tab ferry_terminal \cr
   Transportation \tab fuel \cr
   Transportation \tab grit_bin \cr
   Transportation \tab motorcycle_parking \cr
   Transportation \tab parking \cr
   Transportation \tab parking_entrance \cr
   Transportation \tab parking_space \cr
   Transportation \tab taxi \cr
   Financial \tab atm \cr
   Financial \tab bank \cr
   Financial \tab bureau_de_change \cr
   Healthcare \tab baby_hatch \cr
   Healthcare \tab clinic \cr
   Healthcare \tab dentist \cr
   Healthcare \tab doctors \cr
   Healthcare \tab hospital \cr
   Healthcare \tab nursing_home \cr
   Healthcare \tab pharmacy \cr
   Healthcare \tab social_facility \cr
   Healthcare \tab veterinary \cr
   Entertainment-Arts-Culture \tab arts_centre \cr
   Entertainment-Arts-Culture \tab brothel \cr
   Entertainment-Arts-Culture \tab casino \cr
   Entertainment-Arts-Culture \tab cinema \cr
   Entertainment-Arts-Culture \tab community_centre \cr
   Entertainment-Arts-Culture \tab conference_centre \cr
   Entertainment-Arts-Culture \tab events_venue \cr
   Entertainment-Arts-Culture \tab fountain \cr
   Entertainment-Arts-Culture \tab gambling \cr
   Entertainment-Arts-Culture \tab love_hotel \cr
   Entertainment-Arts-Culture \tab nightclub \cr
   Entertainment-Arts-Culture \tab planetarium \cr
   Entertainment-Arts-Culture \tab public_bookcase \cr
   Entertainment-Arts-Culture \tab social_centre \cr
   Entertainment-Arts-Culture \tab stripclub \cr
   Entertainment-Arts-Culture \tab studio \cr
   Entertainment-Arts-Culture \tab swingerclub \cr
   Entertainment-Arts-Culture \tab theatre \cr
   Public Service \tab courthouse \cr
   Public Service \tab embassy \cr
   Public Service \tab fire_station \cr
   Public Service \tab police \cr
   Public Service \tab post_box \cr
   Public Service \tab post_depot \cr
   Public Service \tab post_office \cr
   Public Service \tab prison \cr
   Public Service \tab ranger_station \cr
   Public Service \tab townhall \cr
   Facilities \tab bbq \cr
   Facilities \tab bench \cr
   Facilities \tab dog_toilet \cr
   Facilities \tab drinking_water \cr
   Facilities \tab give_box \cr
   Facilities \tab shelter \cr
   Facilities \tab shower \cr
   Facilities \tab telephone \cr
   Facilities \tab toilets \cr
   Facilities \tab water_point \cr
   Facilities \tab watering_place \cr
   Waste Management \tab sanitary_dump_station \cr
   Waste Management \tab recycling \cr
   Waste Management \tab waste_basket \cr
   Waste Management \tab waste_disposal \cr
   Waste Management \tab waste_transfer_station \cr
   Others \tab animal_boarding \cr
   Others \tab animal_breeding \cr
   Others \tab animal_shelter \cr
   Others \tab baking_oven \cr
   Others \tab childcare \cr
   Others \tab clock \cr
   Others \tab crematorium \cr
   Others \tab dive_centre \cr
}
}
\note{
Data extracted on \strong{14 June 2021}.
}
\examples{

amenities <- nominatimlite::osm_amenities

amenities
}
\seealso{
Search amenities: 
\code{\link{bbox_to_poly}()},
\code{\link{geo_amenity_sf}()},
\code{\link{geo_amenity}()}
}
\concept{amenity}
\concept{datasets}
