% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/mutualInformation.R
\name{mutualInformation}
\alias{[.mutualInf}
\alias{[[.mutualInf}
\alias{as.numeric.mutualInf}
\alias{mutualInformation}
\alias{plot.mutualInf}
\title{Average Mutual Information (AMI)}
\usage{
mutualInformation(time.series, lag.max = NULL, n.partitions = NULL,
  units = c("Nats", "Bits", "Bans"), do.plot = TRUE, ...)

\method{plot}{mutualInf}(x, main = "Average Mutual Information (AMI)",
  xlab = "Time lag", ylab = NULL, type = "h", ...)

\method{as.numeric}{mutualInf}(x, ...)

\method{[}{mutualInf}(x, i)

\method{[[}{mutualInf}(x, i)
}
\arguments{
\item{time.series}{The observed time series.}

\item{lag.max}{Largest lag at which to calculate the AMI.}

\item{n.partitions}{Number of bins used to compute the probability distribution
of the time series.}

\item{units}{The units for the mutual information. Allowed units are
"Nats", "Bits" or "Bans" (somethings called Hartleys). Default is "Nats".}

\item{do.plot}{Logical value. If TRUE, the AMI is plotted}

\item{...}{Further arguments for the plotting function.}

\item{x}{A \emph{mutualInf} object.}

\item{main}{Title for the plot.}

\item{xlab}{Title for the x axis.}

\item{ylab}{Title for the y axis.}

\item{type}{Type of plot to be drawn.}

\item{i}{Indices specifying elements to extract.}
}
\value{
A \emph{mutualInf} object that consist of a list containing all
the relevant information of the AMI computation:
\emph{time.lag}, \emph{mutual.information}, \emph{units} and \emph{n.partitions}.
}
\description{
Functions for estimating the Average Mutual Information (AMI) of a time
series.
}
\details{
The Average Mutual Information (AMI) measures how much one random variable tells us about
another. In the context of time series analysis, AMI
helps to quantify the amount of knowledge gained about the value
of \eqn{x(t+\tau)}{x(t+tau)} when observing \eqn{x(t)}.

To measure the AMI iof a time series, we create a histogram of the data
using bins. Let \eqn{p_i}{Pi} the probability that the signal has a
value inside the ith bin, and let  \eqn{p_{ij}(\tau)}{Pij(tau)} be
the probability that \eqn{x(t)} is in bin i ans \eqn{x(t+\tau)}{x(t+tau)}
is in bin j. Then, AMI for time delay \eqn{\tau}{tau} is defined as

\deqn{AMI(\tau) = \sum_{i,j} p_{ij} log(\frac{p_{ij}}{p_i p_j})}{
AMI(tau) = sum( Pij log( Pij / (Pi*Pj) ) ) }

Depending on the base of the logarithm used to define AMI, the AMI
is measured in bits (base 2, also called shannons), nats (base e) or
 bans (base 10, also called hartleys).
}
\examples{
\dontrun{
sx = sinaiMap(a=0.3,n.sample=5000,start=c(0.23489,0.8923),do.plot=FALSE)$x
mutinf = mutualInformation(sx, n.partitions = 20, units = "Bits") }
}
\author{
Constantino A. Garcia
}
\references{
H. Kantz  and T. Schreiber: Nonlinear Time series Analysis (Cambridge university press)
H. Abarbanel: Analysis of observed chaotic data (Springer, 1996).
}
\seealso{
\code{\link{timeLag}}
}

