% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonmemica.R
\docType{package}
\name{nonmemica}
\alias{nonmemica}
\title{Create and Evaluate NONMEM Models in a Project Context}
\description{
Nonmemica (emphasis like 'America') creates and evaluates NONMEM
models in a project context.
}
\details{
NONMEM (ICON Development Solutions) is software for nonlinear mixed 
effects modeling. The fundamental interface is a text file (control 
stream, typ. *.mod or *.ctl) that specifies model input, structure, 
and output. There are many add-on interfaces for NONMEM (see references 
for a few examples). However, much day-to-day modeling, even for R users,
involves substantial manual interventions.

Nonmemica streamlines interactions with NONMEM. It adopts some
established conventions and techniques (e.g. from PsN and metrumrg), but 
introduces others that may be useful. Principally, it parses existing 
control streams for systematic analysis and alteration. Relatively simple,
single-problem control streams are supported; see the example.

Of course, NONMEM itself is licensed software that must be installed
independently.  Nonmemica is largely indifferent to how NONMEM is 
installed or invoked. However, several features depend on the *.xml 
output that NONMEM creates; make sure it is available. Also, the 
best-supported directory structure is that which has numbers for 
model names, with all model-specific files in eponymous subdirectories
of a "project" directory. An example is given below.

Nonmemica adopts three control stream encoding conventions that merit
special mention. First, the problem statement is encoded in the form
//like/x//but/y// where x is a reference model name and y is a feature
difference from the reference model (see likebut() ).  This allows any 
given model to be described by chaining together its legacy of features
(use runlog(depenencies = TRUE, ...) ), which generally works better than
 trying to describe it exhaustively in the model name. As of version
 0.9.2, experimental support is available for natural-language
 problem statements of the form "like run1001 but fixed additive error".

Second, Nonmemica only needs a single output table ($TABLE record). 
Be sure to use ONEHEADER but avoid FIRSTONLY.  Nonmemica will integrate
model inputs and outputs, regardless of table counts, into one data.frame
(see superset() ).

Third, Nonmemica supports integrated metadata. With respect to model 
inputs, use package spec to store column metadata in a companion file
(a data specification, e.g. *.spec). Keep the data file and data 
specification in a central location, not copied to the model directory.
For model outputs (tabled items) supply column metadata directly in 
the control stream (or a *.def file; see example and help).

Nonmemica supports three global options: 'project' (default getwd() ) 
is the parent directory of model-specific files or directories; 
'nested' (default TRUE) tells whether model-specific files are nested 
within eponymous directories; 'modex' (default 'ctl') gives the file 
extension for control streams.  In many cases you can pass these 
options to the relevant functions; but since they likely won't change
for the scope of a given project, it saves effort to set them as global 
options (if they differ from the defaults) using e.g. options(project=).

Numbers make good names for models because it is never hard for you
or the software to think of a new one.  That said, model names are
typically processed as character in Nonmemica.  There are many generic
functions with both numeric and character methods that simply assume
the (length-one) argument you supply is a model name.
}
\examples{
\donttest{
# Create a working project.
source <- system.file(package = 'nonmemica','project')
target <- tempdir()
target <- gsub('\\\\\\\\','/',target) # for windows
source
target
file.copy(source,target,recursive = TRUE)
project <- file.path(target,'project','model')

# Point project option at working project
options(project = project)

# Load some packages
library(magrittr)
library(metaplot)
library(wrangle)
library(spec)
library(dplyr,warn.conflicts = FALSE)

# Identify features of a model.
1001 \%>\% modelpath
1001 \%>\% modeldir
1001 \%>\% modelfile
1001 \%>\% modelpath('xml')
1001 \%>\% datafile
datafile(1001) \%matches\% specfile(1001)
1001 \%>\% specfile
1001 \%>\% specfile \%>\% read.spec
1001 \%>\% as.model
1001 \%>\% as.model \%>\% comments
1001 \%>\% definitions
1001 \%>\% runlog(TRUE)
1001 \%>\% runlog
1001 \%>\% partab
1001 \%>\% num_parameters
1001 \%>\% nms_canonical
1001 \%>\% nms_psn
1001 \%>\% nms_nonmem
1001 \%>\% parameters
1001 \%>\% errors
1001 \%>\% as.model \%>\% initial
1001 \%>\% as.model \%>\% lower
1001 \%>\% as.model \%>\% upper
1001 \%>\% as.model \%>\% fixed
1001 \%>\% meta \%>\% class
1001 \%>\% meta

# Derive datasets.
1001 \%>\% superset \%>\% head
1001 \%>\% superset \%>\% filter(VISIBLE == 1) \%>\% group_by(ID,TIME) \%>\% status
1001 \%>\% metasuperset(c('ID','TIME')) \%>\% head
1001 \%>\% metasuperset(c('ID','TIME')) \%>\% sapply(attr,'label')

# Make diagnostic plots.
1001 \%>\% metaplot(
 CWRESI, TAD, SEX, 
 groups = c('ID','TIME'), 
 subset = 'MDV == 0',
 yref=0, 
 ysmooth = TRUE
)
1001 \%>\% metaplot(
 ETA1, SEX, 
 ref = 0,
 groups = c('ID','TIME'),
 subset = 'MDV == 0'
)
1001 \%>\% metaplot(
 SEX, ETA1, 
 ref = 0,
 groups = c('ID','TIME'),
 subset = 'MDV == 0'
)
1001 \%>\% metaplot(
 ETA1, ETA2, ETA3,
 groups = c('ID','TIME'),
 subset = 'MDV == 0'
)

# Derive models.
1001 \%>\% likebut('revised',y = 1002, overwrite=TRUE )
# At this point, edit 1002.ctl to match whatever 'revised' means.
# Then run it with NONMEM and post-process results as above.

# Make ten new models with slightly different initial estimates.
1001 \%>\% tweak
}
}
\references{
\href{https://en.wikipedia.org/wiki/NONMEM}{NONMEM}

\href{https://www.iconplc.com/innovation/nonmem/}{Icon}

\href{https://uupharmacometrics.github.io/PsN/}{PsN}

\href{https://xpose.sourceforge.net/}{Xpose}

\href{https://wfn.sourceforge.net/}{Wings for NONMEM}

\href{https://github.com/MikeKSmith/rspeaksnonmem}{R speaks NONMEM}

\href{https://r-forge.r-project.org/R/?group_id=1215}{metrumrg}
}
