% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rp_test.R
\name{rp.sample}
\alias{rp.sample}
\title{Generates a test statistics sample of random projections}
\usage{
rp.sample(y,k = 2,pars1 = c(100,1),pars2 = c(2,7),seed = NULL)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{k}{an integer with the number of random projections to be used, by default \code{k = 2}.}

\item{pars1}{an optional real vector with the shape parameters of the beta distribution
used for the odd number random projection. By default, \code{pars1 = c(100,1)} where,
\code{shape1 = 100} and \code{shape2 = 1}.}

\item{pars2}{an optional real vector with the shape parameters of the beta distribution
used for the even number random projection. By default, \code{pars2 = c(2,7)} where,
\code{shape1 = 2} and \code{shape2 = 7}.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}
}
\value{
A list with 2 real value vectors:
\itemize{
 \item{"lobato"}{A vector with the Lobato and Velasco's statistics sample}
 \item{"epps"}{A vector with the Epps statistics sample.}
}
}
\description{
Generates a sample of test statistics using k independent random projections
of a stationary process. The first half values of the sample, are estimated
using a Lobato and Velasco's statistic test. The last half values with an Epps
statistic test.
}
\details{
The \code{rp.sample} function generates k independent random projections of the process.
A Lobatos and Velasco's test is applied to the first half of the projections. And an
Epps test for the other half.

For generating the k random projections a beta distribution is used. By default a
\code{beta(shape1 = 100,shape = 1)} and a \code{beta(shape1 = 2,shape = 7)} are used
to generate the odd and even projections respectively. For using a different parameter
set, change \code{pars1} or \code{pars2} values.

The test was proposed by \emph{Nieto-Reyes, A.,Cuesta-Albertos, J. & Gamboa, F. (2014)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
rp.test(y)

}
\references{
Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.

Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.

Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.
}
\seealso{
\code{\link{lobato.test}} \code{\link{epps.test}}
}
\author{
Alicia Nieto-Reyes and Asael Alonzo Matamoros
}
