% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lobato_test.R
\name{lobato.statistic}
\alias{lobato.statistic}
\title{Computes the Lobato and Velasco statistic.}
\usage{
lobato.statistic(y, c = 1)
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary time series.}

\item{c}{a positive real value that identifies the total amount of values used in the
cumulative sum.}
}
\value{
A real value with the Lobato and Velasco test's statistic.
}
\description{
Computes the Lobato and Velasco's statistic. This test  proves a normality
assumption in correlated data employing the skewness-kurtosis test statistic,
but studentized by standard error estimates that are consistent under serial
dependence of the observations.
}
\details{
This function is the equivalent of \code{GestadisticoVn} of \emph{Nieto-Reyes, A.,
Cuesta-Albertos, J. & Gamboa, F. (2014)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
lobato.statistic(y,3)

}
\references{
Lobato, I., & Velasco, C. (2004). A simple test of normality in time series.
\emph{Journal of econometric theory}. 20(4), 671-689.

Nieto-Reyes, A., Cuesta-Albertos, J. & Gamboa, F. (2014). A random-projection
based test of Gaussianity for stationary processes. \emph{Computational
Statistics & Data Analysis, Elsevier}, vol. 75(C), pages 124-141.
}
\seealso{
\code{\link{epps.statistic}}
}
\author{
Alicia Nieto-Reyes and Asael Alonzo Matamoros.
}
