% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vavra_test.R
\name{vavra.sample}
\alias{vavra.sample}
\title{Vávra test's sieve Bootstrap sample for Anderson Darling statistic}
\usage{
vavra.sample(y, normality = c("ad","lobato","jb","cvm","shapiro","epps"),
                    reps = 1000, h = 100, seed = NULL, c = 1, lambda = c(1,2))
}
\arguments{
\item{y}{a numeric vector or an object of the \code{ts} class containing a stationary
time series.}

\item{normality}{A character string naming the desired test for checking normality.
Valid values are \code{"epps"} for the Epps, \code{"lobato"} for Lobato and Velasco's,
\code{"jb"} for the Jarque and Bera, \code{"ad"} for Anderson Darling test,\code{"cvm"}
for the Cramer Von Mises' test, and \code{"shapiro"} for the Shapiro's test.
The default value is \code{"ad"} test.}

\item{reps}{an integer with the total bootstrap repetitions.}

\item{h}{an integer with the first \code{burn-in} sieve bootstrap replicates.}

\item{seed}{An optional \code{\link[=set.seed]{seed}} to use.}

\item{c}{a positive real value used as argument for the Lobato's test.}

\item{lambda}{a numeric vector used as argument for the Epps's test.}
}
\value{
A numeric array with the Anderson Darling sieve bootstrap sample
}
\description{
Generates a sieve bootstrap sample of the Anderson-Darling
statistic test.
}
\details{
The Vávra test approximates the empirical distribution function of the
Anderson-Darlings statistic, using a sieve bootstrap approximation.
The test was proposed by \emph{Psaradakis, Z. & Vávra, M (20.17)}.

This function is the equivalent of \code{xarsieve} of
\emph{Psaradakis, Z. &  Vávra, M (20.17)}.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
adbs = vavra.sample(y)
mean(adbs)

}
\references{
Psaradakis, Z. and Vávra, M. (2020) Normality tests for dependent
data: large-sample and bootstrap approaches. Communications in
\emph{Statistics-Simulation and Computation 49 (2)}. ISSN 0361-0918.

Psaradakis, Z. & Vávra, M. (2017). A distance test of normality for a wide class
of stationary process. \emph{Journal of Econometrics and Statistics}. 2, 50-60.

Bulmann, P. (1997). Sieve Bootstrap for time series. \emph{Bernoulli}.
3(2), 123 -148.
}
\seealso{
\code{\link{epps.statistic}}, \code{\link{lobato.statistic}}
}
\author{
Asael Alonzo Matamoros.
}
