% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_test_overlap.R
\name{t_test_overlap}
\alias{t_test_overlap}
\title{Test for differences in means/percentages between two potentially overlapping groups}
\usage{
t_test_overlap(
  survey_design,
  y_vars,
  na.rm = TRUE,
  status,
  group_1,
  group_2,
  null_difference = 0,
  alternative = "unequal",
  degrees_of_freedom = survey::degf(survey_design) - 1
)
}
\arguments{
\item{survey_design}{A survey design object created with the \code{survey} package.}

\item{y_vars}{Names of dependent variables for tests. For categorical variables, percentages of each category are tested.}

\item{na.rm}{Whether to drop cases with missing values for a given dependent variable.}

\item{status}{The name of the variable representing response/eligibility status.}

\item{group_1}{Vector of values of \code{status} variable representing the first group}

\item{group_2}{Vector of values of \code{status} variable representing the second group}

\item{null_difference}{The hypothesized difference between the groups' means. Default is \code{0}.}

\item{alternative}{Can be one of the following: \cr
\itemize{
\item \code{'unequal'}: two-sided test of whether difference in means is equal to \code{null_difference} \cr
\item \code{'less'}: one-sided test of whether difference is less than \code{null_difference} \cr
\item \code{'greater'}: one-sided test of whether difference is greater than \code{null_difference}
}}

\item{degrees_of_freedom}{The degrees of freedom to use for the test's reference distribution.
Unless specified otherwise, the default is the design degrees of freedom minus one,
where the design degrees of freedom are estimated using the \code{survey} package's \code{degf} method.}
}
\value{
A data frame describing the difference in group means/percentages and the statistics from the t-test
}
\description{
Test for differences in means/percentages between two potentially overlapping groups
}
\keyword{internal}
