% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{dots2env}
\alias{dots2env}
\alias{as.environment.dots}
\title{Make or update an environment with bindings from a dots list.}
\usage{
dots2env(
  x,
  env = new.env(hash = hash, parent = parent, size = size),
  names = NULL,
  use_dots = TRUE,
  append = TRUE,
  hash = (length(dots) > 100),
  size = max(29L, length(dots)),
  parent = emptyenv()
)

\method{as.environment}{dots}(x)
}
\arguments{
\item{x}{A \link{dots} object with names.}

\item{env}{Specify an environment object to populate and return. By
default a new environment is created.}

\item{names}{Which variables to populate in the environment. If
NULL is given, will use all names present in the dotlist.  If a
name is given that does not match any names from the dots object,
an error is raised.}

\item{use_dots}{Whether to bind unnamed or unmatched items to
\code{...}. If FALSE, these items are discarded. If TRUE, they
bound to \code{...} in the environment. If items have duplicate
names, the earlier ones are used and the rest placed in "...".}

\item{append}{if \code{TRUE}, unmatched or unnamed items will be
appended to any existing value of '...'. If \code{FALSE}, the existing
binding of \code{...} will be cleared. (Neither happens if \code{use_dots}
is FALSE.)}

\item{hash}{if \code{env} is NULL, this argument is passed to
\code{\link{new.env}}.}

\item{size}{if \code{env} is NULL, this argument is paseed to
\code{\link{new.env}}.}

\item{parent}{if \code{env} is NULL, this argument is paseed to
\code{\link{new.env}}.}
}
\value{
An environment object.
}
\description{
All named entries in the dots object will be bound to
variables. Unnamed entries will be appended to any existing value
of \code{...} in the order in which they appear.
}
\seealso{
env2dots
}
