% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{plot_phylo_heatmap}
\alias{plot_phylo_heatmap}
\title{Plot single-cell CNV calls along with the clonal phylogeny}
\usage{
plot_phylo_heatmap(
  gtree,
  joint_post,
  segs_consensus,
  annot = NULL,
  pal_annot = NULL,
  annot_title = "Annotation",
  annot_scale = NULL,
  clone_dict = NULL,
  clone_bar = FALSE,
  pal_clone = NULL,
  clone_title = "Genotype",
  clone_legend = TRUE,
  p_min = 0.9,
  line_width = 0.1,
  tree_height = 1,
  branch_width = 0.2,
  tip_length = 0.2,
  clone_line = FALSE,
  superclone = FALSE,
  exclude_gap = FALSE,
  root_edge = TRUE,
  raster = FALSE
)
}
\arguments{
\item{gtree}{tbl_graph The single-cell phylogeny}

\item{joint_post}{dataframe Joint single cell CNV posteriors}

\item{segs_consensus}{datatframe Consensus segment dataframe}

\item{annot}{named vector Cell annotations, keys are cell names}

\item{pal_annot}{named vector Colors for cell annotations}

\item{annot_title}{character Legend title for the annotation bar}

\item{annot_scale}{ggplot scale Color scale for the annotation bar}

\item{clone_dict}{named vector Clone annotations, mapping from cell name to clones}

\item{clone_bar}{logical Whether to display clone bar plot}

\item{pal_clone}{named vector Clone colors}

\item{clone_title}{character Legend title for the clone bar}

\item{clone_legend}{logical Whether to display the clone legend}

\item{p_min}{numeric Probability threshold to display CNV calls}

\item{line_width}{numeric Line width for CNV heatmap}

\item{tree_height}{numeric Relative height of the phylogeny plot}

\item{branch_width}{numeric Line width in the phylogeny}

\item{tip_length}{numeric Length of tips in the phylogeny}

\item{clone_line}{logical Whether to display borders for clones in the heatmap}

\item{superclone}{logical Wehether to display superclones in the clone bar}

\item{exclude_gap}{logical Whether to mark gap regions}

\item{root_edge}{logical Whether to plot root edge}

\item{raster}{logical Whether to raster images}
}
\value{
ggplot panel
}
\description{
Plot single-cell CNV calls along with the clonal phylogeny
}
\examples{
p = plot_phylo_heatmap(
    gtree = phylogeny_example, 
    joint_post = joint_post_example, 
    segs_consensus = segs_example)
}
