% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_pad_zero.R
\name{f_pad_zero}
\alias{f_pad_zero}
\alias{ff_pad_zero}
\title{Pad Numbers with Leading Zeros}
\usage{
f_pad_zero(x, width = NULL, pad.char = "0", ...)

ff_pad_zero(...)
}
\arguments{
\item{x}{A vector of numbers (or string equivalents).}

\item{width}{The width to make the stings.  Defaults to the maximum number of
characters for all elements in \code{x}.}

\item{pad.char}{A character to pad the string with.}

\item{\ldots}{ignored.}
}
\value{
Returns a string of zero padded digits.
}
\description{
Add leading zeros to numbers.
}
\examples{
f_pad_zero(c(NA, 1, 12))
f_pad_zero(c(NA, 1, 100, 10, 1000))
f_pad_zero(as.character(c(NA, 1, 100, 10, 1000)))
f_pad_zero(c(NA, 1, 100, 10, 1000, "B", "BB"))
}
