% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_replace.R
\name{f_replace}
\alias{f_replace}
\alias{ff_replace}
\title{Replace Characters in Strings}
\usage{
f_replace(x, pattern = "_", replacement = " ", ...)

ff_replace(...)
}
\arguments{
\item{x}{A vector of text strings.}

\item{pattern}{A character string defining search patterns.}

\item{replacement}{A character string defining replacement patterns.}

\item{\ldots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a string vector with characters replaced.
}
\description{
A wrapper for \code{\link[base]{gsub}} for replacing substrings that is
useful for \pkg{ggplot2} scales.  Useful for taking field names like
'Cool_Variable' and turning it into 'Cool Variable'.
}
\examples{
f_replace('Cool_Variable')
f_title(f_replace('cool_variable'))
f_replace('Cool_Variable', pattern = '([A-Z])', replacement = '\\\\L\\\\1')
cat(f_replace('really long label names are the pits',
    pattern = '\\\\s', replace = '\n'))
}
\seealso{
\code{\link[base]{strwrap}}
}
