% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etl_extract.R, R/etl_load.R, R/etl_transform.R
\name{etl_extract.etl_nyctaxi}
\alias{etl_extract.etl_nyctaxi}
\alias{etl_load.etl_nyctaxi}
\alias{etl_transform.etl_nyctaxi}
\title{Extract NYC Taxi Trip Data from data from NYC Taxi & Limousine Commission}
\usage{
\method{etl_extract}{etl_nyctaxi}(obj, years = as.numeric(format(Sys.Date(),
  "\%Y")), months = 1:12, types = "yellow", ...)

\method{etl_load}{etl_nyctaxi}(obj, years = as.numeric(format(Sys.Date(),
  "\%Y")), months = 1:12, types = "yellow", ...)

\method{etl_transform}{etl_nyctaxi}(obj, years = as.numeric(format(Sys.Date(),
  "\%Y")), months = 1:12, types = "yellow", ...)
}
\arguments{
\item{obj}{an etl object}

\item{years}{a numeric vector giving the years. The default is the most recent year.}

\item{months}{a numeric vector giving the months. The default is January to December.}

\item{types}{a character vector giving the type of taxi trip data of \code{yellow}}

\item{...}{arguments passed to \code{\link[etl]{smart_download}}
and/or \code{green}. The default is \code{yellow}.}
}
\description{
Extract NYC Taxi Trip Data from data from NYC Taxi & Limousine Commission
}
\details{
extract NYC Yellow taxi trip data from Jan 2009 and 
Green taxi trip data from Aug 2013 data from NYC Taxi & Limousine Commission

load NYC Yellow taxi trip data from load directory into a sql database, 
the default is a sqlite database
and/or \code{green}. The default is \code{yellow}.

transform NYC Yellow taxi trip data from raw directory to load directory
and/or \code{green}. The default is \code{yellow}.
}
\examples{


\dontrun{
taxi <- etl("nyctaxi", dir = "~/Desktop/nyctaxi/")
taxi \%>\% 
   etl_extract(years = 2016, months = 1:2, types = c("yellow","green")) \%>\% 
   etl_transform(years = 2016, months = 1:2, types = c("yellow","green")) \%>\% 
   etl_load(years = 2016, months = 1:2, types = c("yellow","green")) 
}
}
\seealso{
\code{\link[etl]{etl_extract}}

\code{\link[etl]{etl_load}}

\code{\link[etl]{etl_transform}}
}
