% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateLayer.R
\name{generateLayer}
\alias{generateLayer}
\title{Generates a layer.}
\usage{
generateLayer(labbcat.url, layer.id, no.progress = FALSE)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{layer.id}{The ID of the layer to generate.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}
}
\value{
The final status of the layer generation task.
}
\description{
Generates annotations on a given layer for all transcripts in the corpus.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Generate all phonemic transcription annotations
generateLayer(labbcat.url, "phonemes")
}

}
\seealso{
\code{\link{getAllUtterances}}
}
\keyword{annotation}
\keyword{label}
\keyword{layer}
