% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gof.R
\name{gof}
\alias{gof}
\title{Goodness-of-fit assessment of the fitted model.}
\usage{
gof(fit, stats = c("Freeman_Tukey", "deviance"), cores = 1L, plot = TRUE, ...)
}
\arguments{
\item{fit}{An \code{occumbFit} object.}

\item{stats}{The discrepancy statistics to be applied.}

\item{cores}{The number of cores to use for parallelization.}

\item{plot}{Logical, determine if draw scatter plots of the fit statistics.}

\item{...}{Additional arguments passed to the default \code{plot} method.}
}
\value{
A list with the following named elements:
\describe{
\item{\code{stats}}{The discrepancy statistics applied.}
\item{\code{p_value}}{Bayesian \eqn{p}-value.}
\item{\code{stats_obs}}{Discrepancy statistics for observed data.}
\item{\code{stats_rep}}{Discrepancy statistics for repeated data.}
}
}
\description{
\code{gof()} calculates some omnibus discrepancy measures and
their Bayesian \eqn{p}-values for the fitted model using the posterior
predictive check approach.
}
\details{
A discrepancy statistic of the fitted model is obtained using the procedure
of posterior predictive checking.
The following statistics are currently available:
\describe{
\item{Freeman-Tukey statistics (default)}{\eqn{T(\boldsymbol{y}, \boldsymbol{\theta}) = \sum_{i}\sum_{j}\sum_{k}\left(\sqrt{y_{ijk}} - \sqrt{E(y_{ijk} \mid \boldsymbol{\theta})}\right)^2}{\sum_i \sum_j \sum_k (sqrt(y[i, j, k]) - sqrt(E(y[i, j, k] | theta)))^2}}
\item{Deviance statistics}{\eqn{T(\boldsymbol{y}, \boldsymbol{\theta}) = -2 \log p(\boldsymbol{y} \mid \boldsymbol{\theta})}{T(y, theta) = -2 * log(p(y | theta))}}
}
where \eqn{\boldsymbol{y} = \{y_{ijk}\}}{y}, \eqn{\boldsymbol{\theta}}{theta},
\eqn{E(y_{ijk} \mid \boldsymbol{\theta})}{E(y[i, j, k] | theta)}, and
\eqn{\log p(\boldsymbol{y} \mid \boldsymbol{\theta})}{log(p(y | theta))}
are sequence read count data, parameters and latent variables of the model,
expected value of the data conditional on \eqn{\boldsymbol{\theta}}{theta},
and log-likelihood of the model, respectively.
The Bayesian \eqn{p}-value is estimated as the probability that the value of
the discrepancy statistics of replicated dataset is more extreme than that
of the observed dataset.
An extreme Bayesian \eqn{p}-value may indicate an inadequate model fit.
See, e.g., Gelman et al. (2014), Kéry and Royle (2016), and
Conn et al. (2018) for more details on the procedures for posterior
predictive checking.

Computations can be run in parallel on multiple CPU cores where the \code{cores}
argument controls the degree of parallelization.
}
\section{References}{

P. B. Conn, D. S. Johnson, P. J. Williams, S. R. Melin and M. B. Hooten.
(2018) A guide to Bayesian model checking for ecologists.
\emph{Ecological Monographs} \strong{88}:526--542.
\doi{10.1002/ecm.1314}

A. Gelman, J. B. Carlin, H. S. Stern D. B. Dunson, A. Vehtari and
D. B. Rubin (2013) \emph{Bayesian Data Analysis}. 3rd edition.
Chapman and Hall/CRC. \url{http://www.stat.columbia.edu/~gelman/book/}

M. Kéry and J. A. Royle (2016) \emph{Applied Hierarchical Modeling in
Ecology --- Analysis of Distribution, Abundance and Species Richness in R
and BUGS. Volume 1: Prelude and Static Models}. Academic Press.
\url{https://www.mbr-pwrc.usgs.gov/pubanalysis/keryroylebook/}
}

\examples{
\donttest{
# Generate the smallest random dataset (2 species * 2 sites * 2 reps)
I <- 2 # Number of species
J <- 2 # Number of sites
K <- 2 # Number of replicates
data <- occumbData(
    y = array(sample.int(I * J * K), dim = c(I, J, K)),
    spec_cov = list(cov1 = rnorm(I)),
    site_cov = list(cov2 = rnorm(J),
                    cov3 = factor(1:J)),
    repl_cov = list(cov4 = matrix(rnorm(J * K), J, K)))

# Fitting a null model
fit <- occumb(data = data)

# Goodness-of-fit assessment
gof_result <- gof(fit)
gof_result
}
}
