% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{list_cond_R}
\alias{list_cond_R}
\title{Conditions for regional assessment under certain budget and cost values.}
\usage{
list_cond_R(budget, lambda1, lambda2, lambda3, J = NULL, K = NULL)
}
\arguments{
\item{budget}{A numeric specifying budget amount. The currency unit is
arbitrary but must be consistent with that of \code{lambda1}, \code{lambda2}, and \code{lambda3}.}

\item{lambda1}{A numeric specifying the cost per sequence read for
high-throughput sequencing. The currency unit is arbitrary but must be
consistent with that of \code{budget}, \code{lambda2}, and \code{lambda3}.}

\item{lambda2}{A numeric specifying the cost per replicate for library
preparation. The currency unit is arbitrary but must be consistent with that
of \code{budget}, \code{lambda1}, and \code{lambda3}.}

\item{lambda3}{A numeric specifying the visiting cost per site. The currency
unit is arbitrary but must be consistent with that of \code{budget}, \code{lambda1},
and \code{lambda2}.}

\item{J}{An optional vector for manually specifying the number of sites}

\item{K}{An optional vector used to specify the number of replicates manually.
For computational convenience, the \code{K} values must be in ascending order.}
}
\value{
A data frame containing columns named \code{budget}, \code{lambda1}, \code{lambda2},
\code{lambda3}, \code{J}, \code{K}, and \code{N}.
}
\description{
\code{list_cond_R()} constructs a list of possible regional species
diversity assessment conditions under the specified budget and cost values.
}
\details{
This function can generate a data frame object to be given to the
\code{settings} argument of \code{eval_util_R()}; see Examples of \code{eval_util_R()}.
By default, it outputs a list of all feasible combinations of values for the
number of sites \code{J}, number of replicates per site \code{K}, and sequencing
depth per replicate \code{N} based on the given budget and cost values.
The resulting \code{N} can be a non-integer because it is calculated simply by
assuming that the maximum value can be obtained.
If one wants to obtain a list for only a subset of the possible values of \code{J}
and \code{K} under a given budget and cost value, use the \code{J} and/or \code{K}
arguments (in fact, it is recommended that a relatively small number of \code{K}
values be specified using the \code{K} argument because the list of all
conditions achievable under moderate budget and cost values can be large, and
it is rarely practical to have a vast number of replicates per site). If a
given combination of \code{J} and \code{K} values is not feasible under the specified
budget and cost values, the combination will be ignored and excluded from
the output.
}
