% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict,occumbFit-method}
\alias{predict,occumbFit-method}
\title{Predict method for occumbFit class.}
\usage{
\S4method{predict}{occumbFit}(
  object,
  newdata = NULL,
  parameter = c("phi", "theta", "psi"),
  scale = c("response", "link"),
  type = c("quantiles", "mean", "samples")
)
}
\arguments{
\item{object}{An \code{occumbFit} object.}

\item{newdata}{An optional \code{occumbData} object with covariates to be
used for prediction. If omitted, the fitted covariates are used.}

\item{parameter}{The parameter to be predicted.}

\item{scale}{The scale on which the prediction is made.
\code{type = "response"} returns the prediction on the original scale of the
parameter. \code{type = "link"} returns the prediction on the link scale of
the parameter.}

\item{type}{The type of prediction.
\code{type = "quantiles"} returns 50\% quantile as the posterior median of
the prediction in addition to 2.5 and 97.5\% quantiles as the lower and
upper limits of the 95\% credible interval of the prediction.
\code{type = "mean"} returns the posterior mean of the prediction.
\code{type = "samples"} returns the posterior samples of the prediction.}
}
\value{
Predictions are obtained as a matrix or array that can have dimensions
corresponding to statistics (or samples), species, sites, and replicates.
The \code{dimension} and \code{label} attributes are added to the output
object to inform these dimensions.
If the sequence read count data \code{y} has species, site, or replicate
names appended as the \code{dimnames} attribute (see Details in
\code{\link{occumbData}()}), they will be copied into the \code{label}
attribute of the returned object.
}
\description{
Obtain predictions of parameters related to species occupancy
and detection from an \code{occumbFit} model object.
}
\details{
Applying \code{predict()} to an \code{occumbFit} object generates predictions
for the specified parameter (\code{phi}, \code{theta}, or \code{psi}) based
on the estimated effects and the given covariates. It is important to
recognize that the predictions are specific to the individual species being
modeled since they depend on the estimated species-specific effects (i.e.,
\code{alpha}, \code{beta}, and \code{gamma}; see
\href{https://fukayak.github.io/occumb/articles/model_specification.html}{the package vignette} for details).
When providing \code{newdata}, it must thus be assumed that the set of
species contained in \code{newdata} is the same as that of the data being
fitted.
}
