% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adp.rdi.R
\name{read.adp.rdi}
\alias{read.adp.rdi}
\title{Read a Teledyne/RDI ADP File}
\usage{
read.adp.rdi(file, from = 1, to, by = 1, tz = getOption("oceTz"),
  longitude = NA, latitude = NA, type = c("workhorse"), monitor = FALSE,
  despike = FALSE, processingLog, testing = FALSE,
  debug = getOption("oceDebug"), ...)
}
\arguments{
\item{file}{a connection or a character string giving the name of the file
to load.  (For \code{read.adp.sontek.serial}, this is generally a list of
files, which will be concatenated.}

\item{from}{indication of the first profile to read.  This can be an
integer, the sequence number of the first profile to read, or a POSIXt time
before which profiles should be skipped, or a character string that converts
to a POSIXt time (assuming UTC timezone).  See \dQuote{Examples}, and make
careful note of the use of the \code{tz} argument.}

\item{to}{if supplied, an indication of the last profile to read, in a
format as described for \code{from}.  If not supplied, the whole file will
be read.}

\item{by}{an indication of the stride length to use while walking through
the file.  If this is an integer, then \code{by-1} profiles are skipped
between each pair of profiles that is read.  If this is a string
representing a time interval, in colon-separated format (MM:SS), then this
interval is divided by the sampling interval, to get the stride length.}

\item{tz}{character string indicating time zone to be assumed in the data.}

\item{longitude}{optional signed number indicating the longitude in degrees
East.}

\item{latitude}{optional signed number indicating the latitude in degrees
North.}

\item{type}{A character string indicating the type of instrument.}

\item{monitor}{boolean, set to \code{TRUE} to provide an indication (with
numbers and dots) of every profile read.}

\item{despike}{if \code{TRUE}, \code{\link{despike}} will be used to clean
anomalous spikes in heading, etc.}

\item{processingLog}{if provided, the action item to be stored in the log.
(Typically only provided for internal calls; the default that it provides is
better for normal calls by a user.)}

\item{testing}{Logical value, indicating whether 
the time-varying device orientation is to be inferred from the
per-profile header information, and the boolean result is stored in an
integer vector named \code{upward} within the \code{data} slot.}

\item{debug}{a flag that turns on debugging.  Set to 1 to get a moderate
amount of debugging information, or to 2 to get more.}

\item{\dots}{additional arguments, passed to called routines.}
}
\value{
An \code{adp} object, i.e. one inheriting from \code{\link{adp-class}}.
}
\description{
Read a Teledyne/RDI ADCP file (called 'adp' in oce).
}
\details{
As of 2016-09-25, this function has provisional functionality to
read data from the new "SentinelV" series ADCP -- essentially a
combination of a 4 beam workhorse with an additional vertical
centre beam.

If a heading bias had been set with the \code{EB} command during the setup
for the deployment, then a heading bias will have been stored in the file's
header.  This value is stored in the object's metadata as
\code{metadata$heading.bias}.  \strong{Importantly}, this value is
subtracted from the headings stored in the file, and the result of this
subtraction is stored in the objects heading value (in \code{data$heading}).
It should be noted that \code{read.adp.rdi()} was tested for firmware
version 16.30.  For other versions, there may be problems.  For example, the
serial number is not recognized properly for version 16.28.

In Teledyne/RDI ADP data files, velocities are coded to signed 2-byte integers, with a
scale factor being used to convert to velocity in metres per second.  These
two facts control the maximum recordable velocity and the velocity
resolution, values that may be retrieved for an ADP object name \code{d}
with \code{d[["velocityMaximum"]]} and \code{d[["velocityResolution"]]}.
}
\author{
Dan Kelley and Clark Richards
}
\references{
1. Teledyne-RDI, 2007. \emph{WorkHorse commands and output data
format.} P/N 957-6156-00 (November 2007).  (Section 5.3 h details the binary
format, e.g. the file should start with the byte \code{0x7f} repeated twice,
and each profile starts with the bytes \code{0x80}, followed by \code{0x00},
followed by the sequence number of the profile, represented as a
little-endian two-byte short integer.  \code{read.adp.rdi()} uses these
sequences to interpret data files.)
2. Teledyne-RDI, 2015. \emph{V Series output data format.} P/N 95D-6022-00 (May 2015).
}
\seealso{
Other things related to \code{adp} data: \code{\link{[[,adp-method}},
  \code{\link{[[<-,adp-method}}, \code{\link{adp-class}},
  \code{\link{adp}}, \code{\link{as.adp}},
  \code{\link{beamName}}, \code{\link{beamToXyzAdp}},
  \code{\link{beamToXyzAdv}}, \code{\link{beamToXyz}},
  \code{\link{beamUnspreadAdp}}, \code{\link{binmapAdp}},
  \code{\link{enuToOtherAdp}}, \code{\link{enuToOther}},
  \code{\link{plot,adp-method}},
  \code{\link{read.adp.nortek}},
  \code{\link{read.adp.sontek.serial}},
  \code{\link{read.adp.sontek}}, \code{\link{read.adp}},
  \code{\link{read.aquadoppHR}},
  \code{\link{read.aquadoppProfiler}},
  \code{\link{read.aquadopp}},
  \code{\link{subset,adp-method}},
  \code{\link{summary,adp-method}}, \code{\link{toEnuAdp}},
  \code{\link{toEnu}}, \code{\link{velocityStatistics}},
  \code{\link{xyzToEnuAdp}}, \code{\link{xyzToEnu}}
}

