% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{oceProject}
\alias{oceProject}
\title{Wrapper to sf::sf_project()}
\usage{
oceProject(
  xy,
  proj,
  inv = FALSE,
  use_ob_tran,
  legacy,
  passNA,
  debug = getOption("oceDebug")
)
}
\arguments{
\item{xy}{two-column numeric matrix specifying locations.  If \code{inv} is False, then \code{xy[,1]} will hold
longitude and \code{xy[,2]} will hold latitude, but if \code{inv} is True, then the columns will be easting
and northing values (in metres).}

\item{proj}{character string indicating the desired map projection, or an object of class \code{crs};
see \code{\link[sf:sf_project]{sf::sf_project()}}.}

\item{inv}{logical value, False by default, indicating whether an inverse projection is requested.}

\item{use_ob_tran, legacy, passNA}{ignored in oce 1.0.3, and will be disallowed in oce 1.0.4.}

\item{debug}{an integer specifying whether debugging information is
to be printed during the processing. This is a general parameter that
is used by many \code{oce} functions. Generally, setting \code{debug=0}
turns off the printing, while higher values suggest that more information
be printed. If one function calls another, it usually reduces the value of
\code{debug} first, so that a user can often obtain deeper debugging
by specifying higher \code{debug} values.}
}
\value{
A two-column matrix, with first column holding either
\code{longitude} or \code{x}, and second column holding either
\code{latitude} or \code{y}.
}
\description{
This function is used to isolate other oce functions from
changes to the map-projection functions that are done in the \CRANpkg{sf}
package.  (Until 2020 December, the \CRANpkg{rgdal} package was used,
after a year of tests ensuring that the results of the two packages were
the same.)
}
