% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_titre.R
\name{add_titre}
\alias{add_titre}
\title{Add a title on a 'leaflet' map}
\usage{
add_titre(map, titre, sousTitre = NULL)
}
\arguments{
\item{map}{objet leaflet.}

\item{titre}{chaine de caracteres (character). Titre de la carte.}

\item{sousTitre}{chaine de caracteres (character). Sous-titre de la carte.
Par defaut a NULL.}
}
\value{
Retourne un objet de type leaflet.
}
\description{
Add a title on a 'leaflet' map
}
\details{
Pour supprimer le titre ou le sous-titre, reexecutez la fonction add_titre
en laissant le parametre \code{titre} ou \code{sousTitre} a NULL.
}
\examples{

data("donnees_monoloc")
data("depm")

# Ronds proportionnels
map <- leaflet_ronds(data = donnees_monoloc, fondMaille = depm, idData = "COD_DEP",
varVolume = "POP_2015")
map <- add_titre(map = map,
titre = "Population des departements de France metropolitaine en 2015")
\donttest{
 map
}

}
\seealso{
\code{\link{leaflet_ronds}, \link{leaflet_classes},
\link{leaflet_ronds_classes}, \link{leaflet_classes_ronds},
\link{leaflet_typo},}

\code{\link{leaflet_oursins}, \link{leaflet_joignantes},
\link{leaflet_saphirs}}
}
\keyword{documentation}
