% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsApiUserProvisioningManager.R
\docType{class}
\name{ocsApiUserProvisioningManager}
\alias{ocsApiUserProvisioningManager}
\title{ocsApiUserProvisioningManager}
\format{\code{\link{R6Class}} object.}
\usage{
ocsApiUserProvisioningManager
}
\value{
Object of \code{\link{R6Class}} for modelling an ocsManager for Webdav API
}
\description{
ocsApiUserProvisioningManager
}
\section{General Methods (inherited from 'ocsManager')}{

\describe{
 \item{\code{new(url, user, pwd, logger)}}{
   This method is used to instantiate an ocsApiUserProvisioningManager. The user/pwd are
   mandatory in order to connect to 'ocs'. The logger can be either
   NULL, "INFO" (with minimum logs), or "DEBUG" (for complete curl 
   http calls logs)
 }
 \item{\code{connect()}}{
   A method to connect to 'ocs' and set version/capabilities
 }
 \item{\code{getVersion()}}{
   Get the 'ocs' server version
 }
 \item{\code{getCapabilities()}}{
   Get the 'ocs' server capabilities
 }
}
}

\section{User Provisioning API methods}{

\describe{
 \item{\code{addUser(userid, email, password, groups)}}{
   Adds a user given a \code{userid} (required). All other fields (email, password, groups) are
   optional for the user creation. Returns \code{TRUE} if the user is added, \code{FALSE} otherwise.
 }
 \item{\code{getUsers()}}{
   Get the list of users. This method returns a vector of class 'character' giving
   the user IDs available in the OCS cloud plateform.
 }
 \item{\code{getUser(userid, pretty)}}{
   Get the user details from its \code{userid}. If the argument \code{pretty} is set to TRUE,
   this will return an object of class \code{data.frame}, otherwise (by default) it returns 
   an object of class \code{list}.
 }
 \item{\code{editUser(userid, key, value)}}{
   Edits a user, identifier by a userid. The user property to be edited should be set using its
   key (eg display) and the value to be modified for this key. Returns \code{TRUE} if the user 
   is edited, \code{FALSE} otherwise.
 }
 \item{\code{editUserDisplayName(userid, displayName)}}{
   Edits a user display name.
 }
 \item{\code{editUserEmail(userid, email)}}{
   Edits a user email.
 }
 \item{\code{editUserPassword(userid, password)}}{
   Edits a user password.
 }
 \item{\code{editUserQuota(userid, quota)}}{
   Edits a user quota.
 }
 \item{\code{enableUser(userid)}}{
   Enables a user. Returns \code{TRUE} if enabled.
 }
 \item{\code{disableUser(userid)}}{
   Disables a user. Returns \code{TRUE} if disabled.
 }
 \item{\code{deleteUser(userid)}}{
   Deletes a user. Returns \code{TRUE} if deleted.
 }
 \item{\code{getUserGroups(userid)}}{
   Get user group(s). This method returns a vector of class 'character' giving
   the usergroups IDs
 }
 \item{code{addToGroup(userid, groupid)}}{
   Adds a user to a group.
 }
 \item{\code{removeFromGroup(userid, groupid)}}{
   Removes a user from a group.
 }
 \item{\code{getGroups(search, limit, offset)}}{
   Get the list of groups. This method returns a vector of class 'character' giving
   the usergroups IDs
 }
 \item{\code{getGroup(groupid)}}{
   Get the group including member users from its \code{groupid}.
 }
 \item{\code{addGroup(groupid)}}{
   Add group given a \code{groupid} (required).
 }
 \item{\code{deleteGroup(groupid)}}{
   Deletes a group. Returns \code{TRUE} if deleted.
 }
}
}

\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{manager}
\keyword{ocs}
\keyword{userprovisioning}
