% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc.R
\name{odbcSetTransactionIsolationLevel}
\alias{odbcSetTransactionIsolationLevel}
\title{Set the Transaction Isolation Level for a Connection}
\usage{
odbcSetTransactionIsolationLevel(conn, levels)
}
\arguments{
\item{conn}{A \link[DBI:DBIConnection-class]{DBI::DBIConnection} object,
as returned by \code{\link[DBI:dbConnect]{dbConnect()}}.}

\item{levels}{One or more of 'read_uncommitted', 'read_committed', 'repeatable_read', 'serializable'.}
}
\description{
Set the Transaction Isolation Level for a Connection
}
\examples{
\dontrun{
# Can use spaces or underscores in between words.
odbcSetTransactionIsolationLevel(con, "read uncommitted")

# Can also use the full constant name.
odbcSetTransactionIsolationLevel(con, "SQL_TXN_READ_UNCOMMITTED")
}
}
\seealso{
\url{https://learn.microsoft.com/en-us/sql/odbc/reference/develop-app/setting-the-transaction-isolation-level}
}
