% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od.1.R
\name{od.1}
\alias{od.1}
\title{Optimal sample allocation calculation for individual randomized controlled trials}
\usage{
od.1(p = NULL, r12 = NULL, c1 = NULL, c1t = NULL, m = NULL,
  plots = TRUE, plim = NULL, varlim = NULL, plab = NULL,
  varlab = NULL, vartitle = NULL, verbose = TRUE)
}
\arguments{
\item{p}{the proportion of individuals to be assigned to treatment.}

\item{r12}{the proportion of outcome variance explained by covariates.}

\item{c1}{the cost of sampling one unit in control condition.}

\item{c1t}{the cost of sampling one unit in treatment condition.}

\item{m}{total budget, default value is the total costs of sampling 60
individuals across treatment conditions.}

\item{plots}{logical, provide variance plots if TRUE, otherwise not; default value is TRUE.}

\item{plim}{the plot range for p, default value is c(0, 1).}

\item{varlim}{the plot range for variance, default value is c(0, 0.05).}

\item{plab}{the plot label for \code{p} , default value is "Proportion of Individuals in Treatment: p"}

\item{varlab}{the plot label for variance,
default value is "Variance".}

\item{vartitle}{the title of variance plot, default value is NULL.}

\item{verbose}{logical; print the value of \code{p} if TRUE,
otherwise not; default value is TRUE.}
}
\value{
unconstrained or constrained optimal sample allocation (\code{p}).
    The function also returns the variance of treatment effect,
    function name, design type,
    and parameters used in the calculation.
}
\description{
The optimal design of individual randomized controlled trials
    (RCTs) is to choose
    the sample allocation that minimizes the variance of
    treatment effect under fixed budget and cost structure.
    The optimal design parameter is
    the proportion of individuals to be assigned to treatment (\code{p}).
}
\examples{
# unconstrained optimal design #---------
  myod1 <- od.1(r12 = 0.5, c1 = 1, c1t = 5, varlim = c(0, 0.2))
  myod1$out # output

# constrained p, no calculation performed #---------
  myod2 <- od.1(r12 = 0.5, c1 = 1, c1t = 5, varlim = c(0, 0.2), p = 0.5)
  myod2$out
# relative efficiency (RE)
  myre <- re(od = myod1, subod= myod2)
  myre$re # RE = 0.87

# when sampling costs are equal, a balanced  design with p = 0.5 is the best #---------
  myod3 <- od.1(r12 = 0.5, c1 = 1, c1t = 1, varlim = c(0, 0.2))
  myod3$out # output

}
\references{
Shen, Z. (in progress).
  Using optimal sample allocation to
  improve statistical precision and design efficiency for multilevel randomized trials
  (Unpublished doctoral dissertation). University of Cincinnati, Cincinnati, OH.
}
