# My Utilities for Developing R Software <a href="https://loelschlaeger.de/oeli/"><img src="man/figures/logo.png" align="right" height="138" /></a>

<!-- badges: start -->
[![CRAN status](https://www.r-pkg.org/badges/version/oeli)](https://CRAN.R-project.org/package=oeli)
[![R-CMD-check](https://github.com/loelschlaeger/oeli/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/loelschlaeger/oeli/actions/workflows/R-CMD-check.yaml)
[![Codecov test coverage](https://codecov.io/gh/loelschlaeger/oeli/branch/master/graph/badge.svg)](https://app.codecov.io/gh/loelschlaeger/oeli?branch=master)
<!-- badges: end -->

This R package contains some general utilities that I and maybe others find useful when developing data science software:

- [argument validation](https://loelschlaeger.de/oeli/articles/argument_validation.html)

- calculating density values

- catching exceptions

- working with Cholesky roots

- differencing covariance matrices

- working with data frames

- working with dates

- creating a dictionary

- working with functions and their arguments

- estimating hidden Markov models

- working with indices

- working with lists

- creating Markov chains

- working with matrices

- helpers for building an R package

- sampling from densities

- [storing data](https://loelschlaeger.de/oeli/articles/storage_helpers.html)

- timed evaluations

- user interactions

