% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariance_differencing.R
\name{diff_cov}
\alias{diff_cov}
\alias{undiff_cov}
\alias{delta}
\title{Difference and un-difference covariance matrix}
\usage{
diff_cov(cov, ref = 1)

undiff_cov(cov_diff, ref = 1)

delta(ref = 1, dim)
}
\arguments{
\item{cov, cov_diff}{[\code{matrix()}]\cr
A (differenced) covariance matrix of dimension \code{dim}
(or \code{dim} - 1, respectively).}

\item{ref}{[\code{integer(1)}]\cr
The reference row between \code{1} and \code{dim} for
differencing that maps \code{cov} to \code{cov_diff}, see details.}

\item{dim}{[\code{integer(1)}]\cr
The matrix dimension.}
}
\value{
A (differenced or un-differenced) covariance \code{matrix}.
}
\description{
These functions difference and un-difference a covariance matrix with respect
to row \code{ref}.
}
\details{
For differencing: Let \eqn{\Sigma} be a covariance matrix of dimension
\eqn{n}. Then \deqn{\tilde{\Sigma} = \Delta_k \Sigma \Delta_k'}
is the differenced covariance matrix with respect to row \eqn{k = 1,\dots,n},
where \eqn{\Delta_k} is a difference operator that depends on the reference
row \eqn{k}. More precise, \eqn{\Delta_k} the identity matrix of dimension
\eqn{n} without row \eqn{k} and with \eqn{-1}s in column \eqn{k}.
It can be computed with \code{delta(ref = k, dim = n)}.

For un-differencing: The "un-differenced" covariance matrix \eqn{\Sigma}
cannot be uniquely computed from \eqn{\tilde{\Sigma}}.
For a non-unique solution, we add a column and a row of zeros
at column and row number \eqn{k} to \eqn{\tilde{\Sigma}}, respectively, and
add \eqn{1} to each matrix entry to make the result a proper covariance
matrix.
}
\examples{
n <- 3
Sigma <- sample_covariance_matrix(dim = n)
k <- 2

# build difference operator
delta(ref = k, dim = n)

# difference Sigma
(Sigma_diff <- diff_cov(Sigma, ref = k))

# un-difference Sigma
undiff_cov(Sigma_diff, ref = k)
}
\seealso{
Other matrix helpers: 
\code{\link{check_correlation_matrix}()},
\code{\link{check_covariance_matrix}()},
\code{\link{check_transition_probability_matrix}()},
\code{\link{cov_to_chol}()},
\code{\link{insert_matrix_column}()},
\code{\link{matrix_diagonal_indices}()},
\code{\link{matrix_indices}()},
\code{\link{sample_correlation_matrix}()},
\code{\link{sample_covariance_matrix}()},
\code{\link{sample_transition_probability_matrix}()},
\code{\link{stationary_distribution}()}
}
\concept{matrix helpers}
\keyword{transformation}
