% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_pptx.R
\name{read_pptx}
\alias{read_pptx}
\title{open a connexion to a 'PowerPoint' file}
\usage{
read_pptx(path = NULL)
}
\arguments{
\item{path}{path to the pptx file to use as base document.}
}
\description{
read and import a pptx file as an R object
representing the document.
The function is called \code{read_pptx} because it allows you to initialize an
object of class \code{rpptx} from an existing PowerPoint file. Content will be
added to the existing presentation. By default, an empty document is used.
}
\section{master layouts and slide layouts}{

\code{read_pptx()} uses a PowerPoint file as the initial document. This is the original
PowerPoint document where all slide layouts, placeholders for shapes and
styles come from. Major points to be aware of are:
\itemize{
\item Slide layouts are relative to a master layout. A document can contain one or
more master layouts; a master layout can contain one or more slide layouts.
\item A slide layout inherits design properties from its master layout but some
properties can be overwritten.
\item Designs and formatting properties of layouts and shapes (placeholders in a
layout) are defined within the initial document. There is no R function to
modify these values - they must be defined in the initial document.
}
}

\examples{
read_pptx()
}
\seealso{
\code{\link{print.rpptx}} \code{\link{add_slide}}
}
