% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{prop_section}
\alias{prop_section}
\title{Section properties}
\usage{
prop_section(
  page_size = NULL,
  page_margins = NULL,
  type = NULL,
  section_columns = NULL,
  header_default = NULL,
  header_even = NULL,
  header_first = NULL,
  footer_default = NULL,
  footer_even = NULL,
  footer_first = NULL
)
}
\arguments{
\item{page_size}{page dimensions, an object generated with function \link{page_size}.}

\item{page_margins}{page margins, an object generated with function \link{page_mar}.}

\item{type}{Section type. It defines how the contents of the section will be
placed relative to the previous section. Available types are "continuous"
(begins the section on the next paragraph), "evenPage" (begins on the next
even-numbered page), "nextColumn" (begins on the next column on the page),
"nextPage" (begins on the following page), "oddPage" (begins on the next
odd-numbered page).}

\item{section_columns}{section columns, an object generated with function \link{section_columns}. Use NULL (default value) for no content.}

\item{header_default}{content as a \code{\link[=block_list]{block_list()}} for the default page header. Use NULL (default value) for no content.}

\item{header_even}{content as a \code{\link[=block_list]{block_list()}} for the even page header. Use NULL (default value) for no content.}

\item{header_first}{content as a \code{\link[=block_list]{block_list()}} for the first page header. Use NULL (default value) for no content.}

\item{footer_default}{content as a \code{\link[=block_list]{block_list()}} for the default page footer. Use NULL (default value) for no content.}

\item{footer_even}{content as a \code{\link[=block_list]{block_list()}} for the even page footer. Use NULL (default value) for no content.}

\item{footer_first}{content as a \code{\link[=block_list]{block_list()}} for the default page footer. Use NULL (default value) for no content.}
}
\description{
A section is a grouping of blocks (ie. paragraphs and tables)
that have a set of properties that define pages on which the text will appear.

A Section properties object stores information about page composition,
such as page size, page orientation, borders and margins.
}
\note{
There is no support yet for header and footer contents definition.
}
\section{Illustrations}{


\if{html}{\figure{prop_section_doc_1.png}{options: width=80\%}}
}

\examples{
library(officer)

landscape_one_column <- block_section(
  prop_section(
    page_size = page_size(orient = "landscape"), type = "continuous"
  )
)
landscape_two_columns <- block_section(
  prop_section(
    page_size = page_size(orient = "landscape"), type = "continuous",
    section_columns = section_columns(widths = c(4.75, 4.75))
  )
)

doc_1 <- read_docx()
# there starts section with landscape_one_column
doc_1 <- body_add_table(doc_1, value = mtcars[1:10,], style = "table_template")
doc_1 <- body_end_block_section(doc_1, value = landscape_one_column)
# there stops section with landscape_one_column


# there starts section with landscape_two_columns
doc_1 <- body_add_par(doc_1, value = paste(rep(letters, 50), collapse = " "))
doc_1 <- body_end_block_section(doc_1, value = landscape_two_columns)
# there stops section with landscape_two_columns

doc_1 <- body_add_table(doc_1, value = mtcars[1:25,], style = "table_template")

print(doc_1, target = tempfile(fileext = ".docx"))


# an example with headers and footers -----
txt_lorem <- rep(
  "Purus lectus eros metus turpis mattis platea praesent sed. ",
  50)
txt_lorem <- paste0(txt_lorem, collapse = "")

header_first <- block_list(fpar(ftext("text for first page header")))
header_even <- block_list(fpar(ftext("text for even page header")))
header_default <- block_list(fpar(ftext("text for default page header")))
footer_first <- block_list(fpar(ftext("text for first page footer")))
footer_even <- block_list(fpar(ftext("text for even page footer")))
footer_default <- block_list(fpar(ftext("text for default page footer")))

ps <- prop_section(
  header_default = header_default, footer_default = footer_default,
  header_first = header_first, footer_first = footer_first,
  header_even = header_even, footer_even = footer_even
)
x <- read_docx()
for (i in 1:20) {
  x <- body_add_par(x, value = txt_lorem)
}
x <- body_set_default_section(
  x,
  value = ps
)
print(x, target = tempfile(fileext = ".docx"))
}
\seealso{
\link{block_section}

Other functions for section definition: 
\code{\link{page_mar}()},
\code{\link{page_size}()},
\code{\link{section_columns}()}
}
\concept{functions for section definition}
