% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_properties.R
\name{fp_par}
\alias{fp_par}
\alias{fp_par_lite}
\alias{print.fp_par}
\alias{update.fp_par}
\title{Paragraph formatting properties}
\usage{
fp_par(
  text.align = "left",
  padding = 0,
  line_spacing = 1,
  border = fp_border(width = 0),
  padding.bottom,
  padding.top,
  padding.left,
  padding.right,
  border.bottom,
  border.left,
  border.top,
  border.right,
  shading.color = "transparent",
  keep_with_next = FALSE,
  tabs = NULL,
  word_style = "Normal"
)

fp_par_lite(
  text.align = NA,
  padding = NA,
  line_spacing = NA,
  border = FALSE,
  padding.bottom = NA,
  padding.top = NA,
  padding.left = NA,
  padding.right = NA,
  border.bottom = FALSE,
  border.left = FALSE,
  border.top = FALSE,
  border.right = FALSE,
  shading.color = NA,
  keep_with_next = NA,
  tabs = FALSE,
  word_style = NA
)

\method{print}{fp_par}(x, ...)

\method{update}{fp_par}(
  object,
  text.align,
  padding,
  border,
  padding.bottom,
  padding.top,
  padding.left,
  padding.right,
  border.bottom,
  border.left,
  border.top,
  border.right,
  shading.color,
  keep_with_next,
  word_style,
  ...
)
}
\arguments{
\item{text.align}{text alignment - a single character value, expected value
is one of 'left', 'right', 'center', 'justify'.}

\item{padding}{paragraph paddings - 0 or positive integer value. Argument \code{padding} overwrites
arguments \code{padding.bottom}, \code{padding.top}, \code{padding.left}, \code{padding.right}.}

\item{line_spacing}{line spacing, 1 is single line spacing, 2 is double line spacing.}

\item{border}{shortcut for all borders.}

\item{padding.bottom, padding.top, padding.left, padding.right}{paragraph paddings - 0 or positive integer value.}

\item{border.bottom, border.left, border.top, border.right}{\code{\link[=fp_border]{fp_border()}} for
borders. overwrite other border properties.}

\item{shading.color}{shading color - a single character value specifying
a valid color (e.g. "#000000" or "black").}

\item{keep_with_next}{a scalar logical. Specifies that the paragraph (or at least part of it) should be rendered
on the same page as the next paragraph when possible.}

\item{tabs}{NULL (default) for no tabulation marks setting
or an object returned by \code{\link[=fp_tabs]{fp_tabs()}}. Note this can only have effect with Word
or RTF outputs.}

\item{word_style}{Word paragraph style name}

\item{x, object}{\code{fp_par} object}

\item{...}{further arguments - not used}
}
\value{
a \code{fp_par} object
}
\description{
Create a \code{fp_par} object that describes
paragraph formatting properties.

Function \code{fp_par_lite()} is generating properties
with only entries for the parameters users provided. The
undefined properties will inherit from the default settings.
}
\examples{
fp_par(text.align = "center", padding = 5)
obj <- fp_par(text.align = "center", padding = 1)
update(obj, padding.bottom = 5)
}
\seealso{
\link{fpar}

Other functions for defining formatting properties: 
\code{\link{fp_border}()},
\code{\link{fp_cell}()},
\code{\link{fp_tab}()},
\code{\link{fp_tabs}()},
\code{\link{fp_text}()}
}
\concept{functions for defining formatting properties}
