% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_boundary.R
\name{set_boundary}
\alias{set_boundary}
\title{Set boundary}
\usage{
set_boundary(query, boundary = NULL, ...)
}
\arguments{
\item{query}{An \code{ohsome_query} object constructed with \code{\link[=ohsome_query]{ohsome_query()}} or
any of its wrapper functions}

\item{boundary}{Bounding geometries specified by WGS84 coordinates in the
order \verb{lon,lat}. The geometries of \code{sf} are transformed to WGS84 if the CRS
of the object is known. The following classes are supported:
\itemize{
\item \code{sf} with (MULTI)POLYGON geometries
\item \code{sfc} with (MULTI)POLYGON geometries
\item \code{sfg} with (MULTI)POLYGON geometries and WGS 84 coordinates
\item \code{bbox} created with \code{\link[sf:st_bbox]{sf::st_bbox()}} or \code{\link[tmaptools:bb]{tmaptools::bb()}}
\item \code{matrix} created with \code{\link[sp:bbox]{sp::bbox()}} or \code{\link[osmdata:getbb]{osmdata::getbb()}}
\item \code{character} providing textual definitions of bounding polygons, boxes or
circles as allowed by the ohsome API (see
\href{https://docs.ohsome.org/ohsome-api/stable/boundaries.html}{ohsome API - Boundaries}
):
\itemize{
\item bboxes: WGS84 coordinates in the following format:
\code{"id1:lon1,lat1,lon2,lat2|id2:lon1,lat1,lon2,lat2|..."} OR
\code{"lon1,lat1,lon2,lat2|lon1,lat1,lon2,lat2|..."}
\item bcircles: WGS84 coordinates + radius in meter in the following
format: \code{"id1:lon,lat,r|id2:lon,lat,r|..."} OR
\code{"lon,lat,r|lon,lat,r|..."}
\item bpolys: WGS84 coordinates given as a list of coordinate pairs (as for
bboxes) or GeoJSON FeatureCollection. The first point has to be the same
as the last point and MultiPolygons are only supported in GeoJSON.
}
\item \code{list} of \code{bbox}, \code{matrix} or \code{character}. Bounding geometry types of all
list elements must be the same. Does not work with GeoJSON
FeatureCollections.
}}

\item{...}{Additional arguments other than \code{digits} are ignored.}
}
\value{
An \code{ohsome_query} object. The object can be sent to the ohsome API
with \code{\link[=ohsome_post]{ohsome_post()}}. It consists of the following elements:
\itemize{
\item \code{url}: The URL of the endpoint.
\item \code{encode}: The way the information is encoded and then posted to the
ohsome API. Set as \code{"form"}.
\item \code{body}: The parameters of the query such as \code{format}, \code{filter} or
\code{bpolys}.
}
}
\description{
Set or modify the spatial filter of an existing \code{ohsome_query} object
}
\details{
\code{\link[=set_boundary]{set_boundary()}} adds a spatial filter to an \code{ohsome_query} object or
replaces an existing one. The spatial filter of a query to the ohsome API can
be defined as one or more polygons, bounding boxes or bounding circles.
}
\examples{
# Query without boundary definition
q <- ohsome_query(
    "elements/count/groupBy/boundary", 
    filter = "building=*",
    time = "2022-01-01"
)

# Use franconia from the mapview package as bounding polygons
\donttest{
set_boundary(q, mapview::franconia, digits = 4)
}

# Use the bounding box of franconia
\donttest{
set_boundary(q, sf::st_bbox(mapview::franconia))
}

\dontrun{
# Get bounding box of the city of Kigali from OSM
set_boundary(q, osmdata::getbb("Kigali"))
}

# Definition of two named bounding circles
set_boundary(q, c("Circle 1:8.6528,49.3683,1000", "Circle 2:8.7294,49.4376,1000"))

}
\seealso{
\href{https://docs.ohsome.org/ohsome-api/v1/}{ohsome API documentation}
}
