% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{delete_message}
\alias{delete_message}
\title{Delete a message in a specified position from a list}
\usage{
delete_message(x, position = -1)
}
\arguments{
\item{x}{A list of messages.}

\item{position}{The position of the message to delete.}
}
\value{
A list of messages with the message at the specified position removed.
}
\description{
Delete a message using positive or negative positions/indices.
Negative positions/indices can be used to refer to
elements/messages from the end of the sequence.
}
\examples{
messages <- list(
    list(role = "system", content = "Be friendly"),
    list(role = "user", content = "How are you?")
)
delete_message(messages, 1) # delete first message
delete_message(messages, -2) # same as above (delete first message)
delete_message(messages, 2) # delete second message
delete_message(messages, -1) # same as above (delete second message)
}
