% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepaic-forward-regression.R
\name{ols_step_forward_aic}
\alias{ols_step_forward_aic}
\alias{ols_step_forward_aic.default}
\alias{plot.ols_step_forward_aic}
\alias{ols_stepaic_forward}
\title{Stepwise AIC forward regression}
\usage{
ols_step_forward_aic(model, ...)

\method{ols_step_forward_aic}{default}(model, details = FALSE, ...)

\method{plot}{ols_step_forward_aic}(x, ...)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{...}{Other arguments.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_forward_aic}.}
}
\value{
\code{ols_step_forward_aic} returns an object of class \code{"ols_step_forward_aic"}.
An object of class \code{"ols_step_forward_aic"} is a list containing the
following components:

\item{model}{model with the least AIC; an object of class \code{lm}}
\item{steps}{total number of steps}
\item{predictors}{variables added to the model}
\item{aics}{akaike information criteria}
\item{ess}{error sum of squares}
\item{rss}{regression sum of squares}
\item{rsq}{rsquare}
\item{arsq}{adjusted rsquare}
}
\description{
Build regression model from a set of candidate predictor variables by
entering predictors based on akaike information criterion, in a stepwise
manner until there is no variable left to enter any more.
}
\section{Deprecated Function}{

\code{ols_stepaic_forward()} has been deprecated. Instead use \code{ols_step_forward_aic()}.
}

\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_step_forward_aic(model)

# stepwise forward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_forward_aic(model)
plot(k)

# final model
k$model

}
\references{
Venables, W. N. and Ripley, B. D. (2002) Modern Applied Statistics with S. Fourth edition. Springer.
}
\seealso{
Other variable selection procedures: \code{\link{ols_step_all_possible}},
  \code{\link{ols_step_backward_aic}},
  \code{\link{ols_step_backward_p}},
  \code{\link{ols_step_best_subset}},
  \code{\link{ols_step_both_aic}},
  \code{\link{ols_step_forward_p}}
}
