% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flip.r
\name{mirror}
\alias{mirror}
\title{Flip an object}
\usage{
mirror(x, direction = "lr")
}
\arguments{
\item{x}{A vector of numeric or character values, or a matrix or data frame.}

\item{direction}{Only used if \code{x} is a matrix or data frame. Accepted values are \code{'lr'} (left-right mirror) or \code{'ud'} (up-down mirror).}
}
\value{
Object with same class as \code{x}.
}
\description{
This function creates a "mirror" image of a character string, a number, a matrix, or a data frame. For example "Shots were exchanged at the hospital" becomes "latipsoh eht ta degnahcxe erew stohS' and 3.14159 becomes 95141.3. Data frames and matrices will be returned with the order of columns or order of rows reversed.
}
\examples{
x <- 'Shots were exchanged at the hospital'
mirror(x)

x <- c('Water', 'water', 'everywhere')
mirror(x)

# last value will return NA because the exponentiation does not 
# make sense when written backwards
x <- c(3.14159, 2.71828, 6.02214076e+23)

mirror(x)
x <- data.frame(x=1:5, y=6:10)
mirror(x)

x <- matrix(1:10, nrow=2)
mirror(x)
}
