% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockDrugExposure.R
\name{mockDrugExposure}
\alias{mockDrugExposure}
\title{Function to generate drug exposure table}
\usage{
mockDrugExposure(cdm, recordPerson = 1, seed = 1)
}
\arguments{
\item{cdm}{the CDM reference into which the synthetic cohort will be added}

\item{recordPerson}{The expected number of records per person within each cohort. This can help simulate the frequency of observations for individuals in the cohort.}

\item{seed}{A random seed to ensure reproducibility of the generated data.}
}
\value{
A cdm reference with the mock tables
}
\description{
Function to generate drug exposure table
}
\examples{
library(omock)

cdm <- mockCdmReference() |> mockPerson() |> mockObservationPeriod() |>
mockDrugExposure()

cdm$drug_exposure

}
