% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/columns.R
\name{tidyColumns}
\alias{tidyColumns}
\title{Identify tidy columns of a \verb{<summarised_result>}}
\usage{
tidyColumns(result)
}
\arguments{
\item{result}{A \verb{<summarised_result>}.}
}
\value{
Table columns after applying \code{tidy()} function to a
\verb{<summarised_result>}.
}
\description{
Identifies and returns the columns that the tidy version of the
\verb{<summarised_result>} will have.
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = as.integer(c(1, 2)),
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult(settings = tibble(
      "result_id" = c(1, 2), "custom" = c("A", "B")
    ))

  x

  x |> tidyColumns()
}
}
