% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omu_anova.R
\name{omu_anova}
\alias{omu_anova}
\title{Perform anova
Performs an anova across all response variables. The function can take a maximum of 2
independent variables and perform an interaction term between them.}
\usage{
omu_anova(
  count_data,
  metadata,
  response_variable,
  var1,
  var2,
  interaction,
  log_transform,
  p_adjust
)
}
\arguments{
\item{count_data}{A metabolomics count data frame}

\item{metadata}{Metadata dataframe for the metabolomics count data frame}

\item{response_variable}{String of the column header for the response variables,
usually "Metabolite"}

\item{var1}{String of the first independent variable you wish to test}

\item{var2}{String of the second independent variable you wish to test. Optional parameter}

\item{interaction}{Boolean of TRUE or FALSE for whether or not you wish to model
an interaction between independent variables. Optional parameter}

\item{log_transform}{Boolean of TRUE or FALSE for whether or not you wish to log transform
your metabolite counts}

\item{p_adjust}{Method for p value adjustment, i.e. "BH"}
}
\description{
Perform anova
Performs an anova across all response variables. The function can take a maximum of 2
independent variables and perform an interaction term between them.
}
\examples{
\dontshow{c57_nos2KO_mouse_countDF <- c57_nos2KO_mouse_countDF[1:12,]}
anova_df <- omu_anova(count_data = c57_nos2KO_mouse_countDF, metadata = c57_nos2KO_mouse_metadata,
response_variable = "Metabolite", var1 = "Treatment", var2 = "Background", log_transfor = TRUE,
p_adjust = "BH", interaction = TRUE)
}
